/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.cloud.config;

import com.netflix.discovery.EurekaClient;
import de.codecentric.boot.admin.server.cloud.discovery.DefaultServiceInstanceConverter;
import de.codecentric.boot.admin.server.cloud.discovery.EurekaServiceInstanceConverter;
import de.codecentric.boot.admin.server.cloud.discovery.InstanceDiscoveryListener;
import de.codecentric.boot.admin.server.cloud.discovery.ServiceInstanceConverter;
import de.codecentric.boot.admin.server.config.AdminServerAutoConfiguration;
import de.codecentric.boot.admin.server.config.AdminServerMarkerConfiguration;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.services.InstanceRegistry;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnSingleCandidate(value=DiscoveryClient.class)
@ConditionalOnBean(value={AdminServerMarkerConfiguration.Marker.class})
@ConditionalOnProperty(prefix="spring.boot.admin.discovery", name={"enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={AdminServerAutoConfiguration.class}, name={"org.springframework.cloud.netflix.eureka.EurekaClientAutoConfiguration", "org.springframework.cloud.client.discovery.simple.SimpleDiscoveryClientAutoConfiguration"})
public class AdminServerDiscoveryAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(prefix="spring.boot.admin.discovery")
    public InstanceDiscoveryListener instanceDiscoveryListener(ServiceInstanceConverter serviceInstanceConverter, DiscoveryClient discoveryClient, InstanceRegistry registry, InstanceRepository repository) {
        InstanceDiscoveryListener listener = new InstanceDiscoveryListener(discoveryClient, registry, repository);
        listener.setConverter(serviceInstanceConverter);
        return listener;
    }

    @Bean
    @ConditionalOnMissingBean(value={ServiceInstanceConverter.class})
    @ConfigurationProperties(prefix="spring.boot.admin.discovery.converter")
    public DefaultServiceInstanceConverter serviceInstanceConverter() {
        return new DefaultServiceInstanceConverter();
    }

    @Configuration
    @ConditionalOnMissingBean(value={ServiceInstanceConverter.class})
    @ConditionalOnBean(value={EurekaClient.class})
    public static class EurekaConverterConfiguration {
        @Bean
        @ConfigurationProperties(prefix="spring.boot.admin.discovery.converter")
        public EurekaServiceInstanceConverter serviceInstanceConverter() {
            return new EurekaServiceInstanceConverter();
        }
    }
}

