/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff;

import de.danielbechler.diff.CircularReferenceDetector;
import de.danielbechler.diff.Configurable;
import de.danielbechler.diff.Configuration;
import de.danielbechler.diff.DelegatingObjectDiffer;
import de.danielbechler.diff.Differ;
import de.danielbechler.diff.Instances;
import de.danielbechler.diff.node.Node;
import de.danielbechler.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractDiffer<T extends Node>
implements Differ<T>,
Configurable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDiffer.class);
    static final ThreadLocal<CircularReferenceDetector> WORKING_CIRCULAR_REFERENCE_DETECTOR_THREAD_LOCAL = new CircularReferenceDetectorThreadLocal();
    static final ThreadLocal<CircularReferenceDetector> BASE_CIRCULAR_REFERENCE_DETECTOR_THREAD_LOCAL = new CircularReferenceDetectorThreadLocal();
    private DelegatingObjectDiffer delegate;

    protected AbstractDiffer() {
    }

    protected AbstractDiffer(DelegatingObjectDiffer delegate) {
        Assert.notNull(delegate, "delegate");
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T compare(Node parentNode, Instances instances) {
        T node;
        CircularReferenceDetector workingCircularReferenceDetector = WORKING_CIRCULAR_REFERENCE_DETECTOR_THREAD_LOCAL.get();
        CircularReferenceDetector baseCircularReferenceDetector = BASE_CIRCULAR_REFERENCE_DETECTOR_THREAD_LOCAL.get();
        boolean destroyOnReturn = workingCircularReferenceDetector.isNew();
        try {
            workingCircularReferenceDetector.push(instances.getWorking());
            baseCircularReferenceDetector.push(instances.getBase());
            try {
                node = this.internalCompare(parentNode, instances);
            }
            finally {
                workingCircularReferenceDetector.remove(instances.getWorking());
                baseCircularReferenceDetector.remove(instances.getBase());
            }
        }
        catch (CircularReferenceDetector.CircularReferenceException e) {
            node = this.newNode(parentNode, instances);
            node.setState(Node.State.CIRCULAR);
            logger.warn("Detected circular reference in node at path {}. Going deeper would cause an infinite loop, so I'll stop looking at this instance along the current path.", (Object)node.getPropertyPath());
        }
        if (destroyOnReturn) {
            WORKING_CIRCULAR_REFERENCE_DETECTOR_THREAD_LOCAL.remove();
            BASE_CIRCULAR_REFERENCE_DETECTOR_THREAD_LOCAL.remove();
        }
        return node;
    }

    protected abstract T internalCompare(Node var1, Instances var2);

    protected abstract T newNode(Node var1, Instances var2);

    public final DelegatingObjectDiffer getDelegate() {
        return this.delegate;
    }

    public final void setDelegate(DelegatingObjectDiffer delegate) {
        Assert.notNull(delegate, "delegate");
        this.delegate = delegate;
    }

    @Override
    public final Configuration getConfiguration() {
        return this.delegate.getConfiguration();
    }

    private static final class CircularReferenceDetectorThreadLocal
    extends ThreadLocal<CircularReferenceDetector> {
        private CircularReferenceDetectorThreadLocal() {
        }

        @Override
        protected CircularReferenceDetector initialValue() {
            return new CircularReferenceDetector();
        }
    }
}

