/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff;

import de.danielbechler.diff.AbstractDiffer;
import de.danielbechler.diff.Configuration;
import de.danielbechler.diff.DelegatingObjectDiffer;
import de.danielbechler.diff.Instances;
import de.danielbechler.diff.node.DefaultNode;
import de.danielbechler.diff.node.Node;

public class PrimitiveDiffer
extends AbstractDiffer<Node> {
    public PrimitiveDiffer(DelegatingObjectDiffer delegatingObjectDiffer) {
        super(delegatingObjectDiffer);
    }

    @Override
    protected Node internalCompare(Node parentNode, Instances instances) {
        if (!instances.getType().isPrimitive()) {
            throw new IllegalArgumentException("The primitive differ can only deal with primitive types.");
        }
        Node node = this.newNode(parentNode, instances);
        if (this.getDelegate().isIgnored(node)) {
            node.setState(Node.State.IGNORED);
        } else if (this.shouldTreatPrimitiveDefaultsAsUnassigned() && instances.hasBeenAdded()) {
            node.setState(Node.State.ADDED);
        } else if (this.shouldTreatPrimitiveDefaultsAsUnassigned() && instances.hasBeenRemoved()) {
            node.setState(Node.State.REMOVED);
        } else if (!instances.areEqual()) {
            node.setState(Node.State.CHANGED);
        }
        return node;
    }

    private boolean shouldTreatPrimitiveDefaultsAsUnassigned() {
        return this.getDelegate().getConfiguration().getPrimitiveDefaultValueMode() == Configuration.PrimitiveDefaultValueMode.UNASSIGNED;
    }

    @Override
    protected Node newNode(Node parentNode, Instances instances) {
        return new DefaultNode(parentNode, instances.getSourceAccessor(), instances.getType());
    }
}

