/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff;

import de.danielbechler.diff.BeanPropertyComparisonDelegator;
import de.danielbechler.diff.DefaultNodeFactory;
import de.danielbechler.diff.Differ;
import de.danielbechler.diff.DifferDelegator;
import de.danielbechler.diff.Instances;
import de.danielbechler.diff.NodeInspector;
import de.danielbechler.diff.TestOnly;
import de.danielbechler.diff.accessor.Accessor;
import de.danielbechler.diff.introspect.Introspector;
import de.danielbechler.diff.introspect.StandardIntrospector;
import de.danielbechler.diff.node.DefaultNode;
import de.danielbechler.diff.node.Node;
import de.danielbechler.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BeanDiffer
implements Differ<Node> {
    private final NodeInspector nodeInspector;
    private Introspector introspector = new StandardIntrospector();
    private BeanPropertyComparisonDelegator beanPropertyComparisonDelegator;
    private DefaultNodeFactory defaultNodeFactory = new DefaultNodeFactory();

    public BeanDiffer(DifferDelegator delegator, NodeInspector nodeInspector) {
        Assert.notNull(delegator, "delegator");
        Assert.notNull(nodeInspector, "configuration");
        this.beanPropertyComparisonDelegator = new BeanPropertyComparisonDelegator(delegator, nodeInspector);
        this.nodeInspector = nodeInspector;
    }

    @Override
    public final Node compare(Node parentNode, Instances instances) {
        DefaultNode beanNode = this.defaultNodeFactory.createNode(parentNode, instances);
        if (this.nodeInspector.isIgnored(beanNode)) {
            beanNode.setState(Node.State.IGNORED);
        } else if (instances.areNull() || instances.areSame()) {
            beanNode.setState(Node.State.UNTOUCHED);
        } else if (instances.hasBeenAdded()) {
            this.compareUsingAppropriateMethod(beanNode, instances);
            beanNode.setState(Node.State.ADDED);
        } else if (instances.hasBeenRemoved()) {
            this.compareUsingAppropriateMethod(beanNode, instances);
            beanNode.setState(Node.State.REMOVED);
        } else {
            this.compareUsingAppropriateMethod(beanNode, instances);
        }
        return beanNode;
    }

    private void compareUsingAppropriateMethod(Node beanNode, Instances instances) {
        if (this.nodeInspector.isIntrospectible(beanNode)) {
            this.compareUsingIntrospection(beanNode, instances);
        } else if (this.nodeInspector.isEqualsOnly(beanNode)) {
            this.compareUsingEquals(beanNode, instances);
        }
    }

    private void compareUsingIntrospection(Node beanNode, Instances beanInstances) {
        Class<?> beanType = beanInstances.getType();
        Iterable<Accessor> propertyAccessors = this.introspector.introspect(beanType);
        for (Accessor propertyAccessor : propertyAccessors) {
            Node propertyNode = this.beanPropertyComparisonDelegator.compare(beanNode, beanInstances, propertyAccessor);
            if (!this.nodeInspector.isReturnable(propertyNode)) continue;
            beanNode.addChild(propertyNode);
        }
    }

    private void compareUsingEquals(Node beanNode, Instances instances) {
        if (instances.areEqual()) {
            beanNode.setState(Node.State.UNTOUCHED);
        } else {
            beanNode.setState(Node.State.CHANGED);
        }
    }

    @TestOnly
    void setIntrospector(Introspector introspector) {
        Assert.notNull(introspector, "introspector");
        this.introspector = introspector;
    }

    @TestOnly
    void setBeanPropertyComparisonDelegator(BeanPropertyComparisonDelegator beanPropertyComparisonDelegator) {
        Assert.notNull(beanPropertyComparisonDelegator, "beanPropertyComparisonDelegator");
        this.beanPropertyComparisonDelegator = beanPropertyComparisonDelegator;
    }

    @TestOnly
    public void setDefaultNodeFactory(DefaultNodeFactory defaultNodeFactory) {
        Assert.notNull(defaultNodeFactory, "defaultNodeFactory");
        this.defaultNodeFactory = defaultNodeFactory;
    }
}

