/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Collections {
    private Collections() {
    }

    public static <T> Set<T> setOf(T ... c) {
        return Collections.setOf(Arrays.asList(c));
    }

    public static <T> Set<T> setOf(Collection<T> c) {
        return new LinkedHashSet<T>(c);
    }

    public static boolean isEmpty(Collection<?> c) {
        return c == null || c.isEmpty();
    }

    public static <T> boolean containsAny(Iterable<T> haystack, Iterable<T> needles) {
        for (T straw : haystack) {
            for (T needle : needles) {
                if (!straw.equals(needle)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> T get(Iterable<T> haystack, T needle) {
        for (T t : haystack) {
            if (!t.equals(needle)) continue;
            return t;
        }
        return null;
    }

    public static <T> int indexOf(Iterable<? extends T> haystack, T needle) {
        int index = 0;
        for (T item : haystack) {
            if (item.equals(needle)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static <T> Collection<? extends T> filteredCopyOf(Collection<? extends T> source, Collection<? extends T> filter) {
        LinkedList<Object> copy = source != null ? new LinkedList<T>(source) : new LinkedList();
        if (filter != null) {
            copy.removeAll(new ArrayList<T>(filter));
        }
        return copy;
    }

    public static <T> Collection<? extends T> maskedCopyOf(Collection<? extends T> source, Collection<? extends T> mask) {
        LinkedList<T> copy = new LinkedList<T>(source);
        copy.retainAll(new ArrayList<T>(mask));
        return copy;
    }

    public static <T> T firstElementOf(Collection<? extends T> items) {
        if (items != null && !items.isEmpty()) {
            return items.iterator().next();
        }
        return null;
    }

    public static <T> T lastElementOf(List<? extends T> items) {
        if (items != null && !items.isEmpty()) {
            return items.get(items.size() - 1);
        }
        return null;
    }

    public static <T> T lastElementOf(Collection<? extends T> items) {
        if (items != null && !items.isEmpty()) {
            Iterator<T> iterator = items.iterator();
            while (iterator.hasNext()) {
                T t = iterator.next();
                if (iterator.hasNext()) continue;
                return t;
            }
        }
        return null;
    }
}

