/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.differ;

import de.danielbechler.diff.access.Instances;
import de.danielbechler.diff.access.PropertyAwareAccessor;
import de.danielbechler.diff.comparison.ComparisonStrategy;
import de.danielbechler.diff.comparison.ComparisonStrategyResolver;
import de.danielbechler.diff.differ.Differ;
import de.danielbechler.diff.differ.DifferDispatcher;
import de.danielbechler.diff.filtering.IsReturnableResolver;
import de.danielbechler.diff.introspection.Introspector;
import de.danielbechler.diff.introspection.IntrospectorResolver;
import de.danielbechler.diff.introspection.IsIntrospectableResolver;
import de.danielbechler.diff.node.DiffNode;
import de.danielbechler.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeanDiffer
implements Differ {
    private final IsIntrospectableResolver isIntrospectableResolver;
    private final IsReturnableResolver isReturnableResolver;
    private final ComparisonStrategyResolver comparisonStrategyResolver;
    private final IntrospectorResolver introspectorResolver;
    private final DifferDispatcher differDispatcher;

    public BeanDiffer(DifferDispatcher differDispatcher, IsIntrospectableResolver introspectableResolver, IsReturnableResolver returnableResolver, ComparisonStrategyResolver comparisonStrategyResolver, IntrospectorResolver introspectorResolver) {
        Assert.notNull(differDispatcher, "differDispatcher");
        this.differDispatcher = differDispatcher;
        Assert.notNull(introspectableResolver, "introspectableResolver");
        this.isIntrospectableResolver = introspectableResolver;
        Assert.notNull(returnableResolver, "returnableResolver");
        this.isReturnableResolver = returnableResolver;
        Assert.notNull(comparisonStrategyResolver, "comparisonStrategyResolver");
        this.comparisonStrategyResolver = comparisonStrategyResolver;
        Assert.notNull(introspectorResolver, "introspectorResolver");
        this.introspectorResolver = introspectorResolver;
    }

    @Override
    public boolean accepts(Class<?> type) {
        return !type.isPrimitive() && !type.isArray();
    }

    @Override
    public final DiffNode compare(DiffNode parentNode, Instances instances) {
        DiffNode beanNode = new DiffNode(parentNode, instances.getSourceAccessor(), instances.getType());
        if (instances.areNull() || instances.areSame()) {
            beanNode.setState(DiffNode.State.UNTOUCHED);
        } else if (instances.hasBeenAdded()) {
            this.compareUsingAppropriateMethod(beanNode, instances);
            beanNode.setState(DiffNode.State.ADDED);
        } else if (instances.hasBeenRemoved()) {
            this.compareUsingAppropriateMethod(beanNode, instances);
            beanNode.setState(DiffNode.State.REMOVED);
        } else {
            this.compareUsingAppropriateMethod(beanNode, instances);
        }
        return beanNode;
    }

    private void compareUsingAppropriateMethod(DiffNode beanNode, Instances instances) {
        ComparisonStrategy comparisonStrategy = this.comparisonStrategyResolver.resolveComparisonStrategy(beanNode);
        if (comparisonStrategy != null) {
            comparisonStrategy.compare(beanNode, instances.getType(), instances.getWorking(), instances.getBase());
        } else if (this.isIntrospectableResolver.isIntrospectable(beanNode)) {
            this.compareUsingIntrospection(beanNode, instances);
        }
    }

    private void compareUsingIntrospection(DiffNode beanNode, Instances beanInstances) {
        Class<?> beanType = beanInstances.getType();
        Introspector introspector = this.introspectorResolver.introspectorForNode(beanNode);
        Iterable<PropertyAwareAccessor> propertyAccessors = introspector.introspect(beanType);
        for (PropertyAwareAccessor propertyAccessor : propertyAccessors) {
            DiffNode propertyNode = this.differDispatcher.dispatch(beanNode, beanInstances, propertyAccessor);
            if (!this.isReturnableResolver.isReturnable(propertyNode)) continue;
            beanNode.addChild(propertyNode);
        }
    }
}

