/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.differ;

import de.danielbechler.diff.access.Accessor;
import de.danielbechler.diff.access.Instances;
import de.danielbechler.diff.circular.CircularReferenceDetector;
import de.danielbechler.diff.circular.CircularReferenceDetectorFactory;
import de.danielbechler.diff.circular.CircularReferenceExceptionHandler;
import de.danielbechler.diff.differ.Differ;
import de.danielbechler.diff.differ.DifferProvider;
import de.danielbechler.diff.filtering.IsReturnableResolver;
import de.danielbechler.diff.inclusion.IsIgnoredResolver;
import de.danielbechler.diff.node.DiffNode;
import de.danielbechler.diff.path.NodePath;
import de.danielbechler.diff.selector.ElementSelector;
import de.danielbechler.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DifferDispatcher {
    private static final Logger logger = LoggerFactory.getLogger(DifferDispatcher.class);
    private final DifferProvider differProvider;
    private final CircularReferenceDetectorFactory circularReferenceDetectorFactory;
    private final CircularReferenceExceptionHandler circularReferenceExceptionHandler;
    private final IsIgnoredResolver isIgnoredResolver;
    private final IsReturnableResolver isReturnableResolver;
    CircularReferenceDetector workingCircularReferenceDetector;
    CircularReferenceDetector baseCircularReferenceDetector;

    public DifferDispatcher(DifferProvider differProvider, CircularReferenceDetectorFactory circularReferenceDetectorFactory, CircularReferenceExceptionHandler circularReferenceExceptionHandler, IsIgnoredResolver ignoredResolver, IsReturnableResolver returnableResolver) {
        Assert.notNull(differProvider, "differFactory");
        this.differProvider = differProvider;
        Assert.notNull(ignoredResolver, "ignoredResolver");
        this.isIgnoredResolver = ignoredResolver;
        this.circularReferenceDetectorFactory = circularReferenceDetectorFactory;
        this.circularReferenceExceptionHandler = circularReferenceExceptionHandler;
        this.isReturnableResolver = returnableResolver;
        this.resetInstanceMemory();
    }

    protected final void resetInstanceMemory() {
        this.workingCircularReferenceDetector = this.circularReferenceDetectorFactory.createCircularReferenceDetector();
        this.baseCircularReferenceDetector = this.circularReferenceDetectorFactory.createCircularReferenceDetector();
    }

    public DiffNode dispatch(DiffNode parentNode, Instances parentInstances, Accessor accessor) {
        Assert.notNull(parentInstances, "parentInstances");
        Assert.notNull(accessor, "accessor");
        DiffNode node = this.compare(parentNode, parentInstances, accessor);
        if (parentNode != null && this.isReturnableResolver.isReturnable(node)) {
            parentNode.addChild(node);
        }
        return node;
    }

    private DiffNode compare(DiffNode parentNode, Instances parentInstances, Accessor accessor) {
        DiffNode node = new DiffNode(parentNode, accessor, null);
        if (this.isIgnoredResolver.isIgnored(node)) {
            node.setState(DiffNode.State.IGNORED);
            return node;
        }
        Instances accessedInstances = parentInstances.access(accessor);
        if (accessedInstances.areNull()) {
            return new DiffNode(parentNode, accessedInstances.getSourceAccessor(), accessedInstances.getType());
        }
        return this.compareWithCircularReferenceTracking(parentNode, accessedInstances);
    }

    private DiffNode compareWithCircularReferenceTracking(DiffNode parentNode, Instances instances) {
        DiffNode node = null;
        try {
            this.rememberInstances(parentNode, instances);
            try {
                node = this.compare(parentNode, instances);
            }
            finally {
                if (node != null) {
                    this.forgetInstances(parentNode, instances);
                }
            }
        }
        catch (CircularReferenceDetector.CircularReferenceException e) {
            node = DifferDispatcher.newCircularNode(parentNode, instances, e.getNodePath());
            this.circularReferenceExceptionHandler.onCircularReferenceException(node);
        }
        if (parentNode == null) {
            this.resetInstanceMemory();
        }
        return node;
    }

    private DiffNode compare(DiffNode parentNode, Instances instances) {
        Differ differ = this.differProvider.retrieveDifferForType(instances.getType());
        if (differ == null) {
            throw new IllegalStateException("Couldn't create Differ for type '" + instances.getType() + "'. This mustn't happen, as there should always be a fallback differ.");
        }
        return differ.compare(parentNode, instances);
    }

    protected void forgetInstances(DiffNode parentNode, Instances instances) {
        NodePath nodePath;
        if (parentNode != null) {
            NodePath parentPath = parentNode.getPath();
            ElementSelector elementSelector = instances.getSourceAccessor().getElementSelector();
            nodePath = NodePath.startBuildingFrom(parentPath).element(elementSelector).build();
        } else {
            nodePath = NodePath.withRoot();
        }
        logger.debug("[ {} ] Forgetting --- WORKING: {} <=> BASE: {}", new Object[]{nodePath, instances.getWorking(), instances.getBase()});
        this.workingCircularReferenceDetector.remove(instances.getWorking());
        this.baseCircularReferenceDetector.remove(instances.getBase());
    }

    protected void rememberInstances(DiffNode parentNode, Instances instances) {
        NodePath nodePath;
        if (parentNode != null) {
            NodePath parentPath = parentNode.getPath();
            ElementSelector elementSelector = instances.getSourceAccessor().getElementSelector();
            nodePath = NodePath.startBuildingFrom(parentPath).element(elementSelector).build();
        } else {
            nodePath = NodePath.withRoot();
        }
        logger.debug("[ {} ] Remembering --- WORKING: {} <=> BASE: {}", new Object[]{nodePath, instances.getWorking(), instances.getBase()});
        this.transactionalPushToCircularReferenceDetectors(nodePath, instances);
    }

    private void transactionalPushToCircularReferenceDetectors(NodePath nodePath, Instances instances) {
        this.workingCircularReferenceDetector.push(instances.getWorking(), nodePath);
        try {
            this.baseCircularReferenceDetector.push(instances.getBase(), nodePath);
        }
        catch (CircularReferenceDetector.CircularReferenceException e) {
            this.workingCircularReferenceDetector.remove(instances.getWorking());
            throw e;
        }
    }

    private static DiffNode findNodeMatchingPropertyPath(DiffNode node, NodePath nodePath) {
        if (node == null) {
            return null;
        }
        if (node.matches(nodePath)) {
            return node;
        }
        return DifferDispatcher.findNodeMatchingPropertyPath(node.getParentNode(), nodePath);
    }

    private static DiffNode newCircularNode(DiffNode parentNode, Instances instances, NodePath circleStartPath) {
        DiffNode node = new DiffNode(parentNode, instances.getSourceAccessor(), instances.getType());
        node.setState(DiffNode.State.CIRCULAR);
        node.setCircleStartPath(circleStartPath);
        node.setCircleStartNode(DifferDispatcher.findNodeMatchingPropertyPath(parentNode, circleStartPath));
        return node;
    }
}

