/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.util;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Classes {
    private static final Logger logger = LoggerFactory.getLogger(Classes.class);
    private static final Set<Class<?>> WRAPPER_TYPES = Classes.getWrapperTypes();
    private static final Collection<Class<?>> PRIMITIVE_NUMERIC_TYPES = Classes.getPrimitiveNumericTypes();

    private Classes() {
    }

    private static Set<Class<?>> getWrapperTypes() {
        HashSet wrapperTypes = new HashSet();
        wrapperTypes.add(Boolean.class);
        wrapperTypes.add(Character.class);
        wrapperTypes.add(Byte.class);
        wrapperTypes.add(Short.class);
        wrapperTypes.add(Integer.class);
        wrapperTypes.add(Long.class);
        wrapperTypes.add(Float.class);
        wrapperTypes.add(Double.class);
        wrapperTypes.add(Void.class);
        return wrapperTypes;
    }

    public static boolean isPrimitiveNumericType(Class<?> clazz) {
        return PRIMITIVE_NUMERIC_TYPES.contains(clazz);
    }

    private static Collection<Class<?>> getPrimitiveNumericTypes() {
        HashSet numericTypes = new HashSet();
        numericTypes.add(Character.TYPE);
        numericTypes.add(Byte.TYPE);
        numericTypes.add(Short.TYPE);
        numericTypes.add(Integer.TYPE);
        numericTypes.add(Long.TYPE);
        numericTypes.add(Float.TYPE);
        numericTypes.add(Double.TYPE);
        return numericTypes;
    }

    public static boolean isSimpleType(Class<?> clazz) {
        if (clazz != null) {
            if (Classes.isPrimitiveType(clazz)) {
                return true;
            }
            if (Classes.isPrimitiveWrapperType(clazz)) {
                return true;
            }
            if (clazz.isEnum()) {
                return true;
            }
            if (CharSequence.class.isAssignableFrom(clazz)) {
                return true;
            }
            if (Number.class.isAssignableFrom(clazz)) {
                return true;
            }
            if (Date.class.isAssignableFrom(clazz)) {
                return true;
            }
            if (URI.class.equals(clazz)) {
                return true;
            }
            if (URL.class.equals(clazz)) {
                return true;
            }
            if (Locale.class.equals(clazz)) {
                return true;
            }
            if (Class.class.equals(clazz)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isPrimitiveType(Class<?> clazz) {
        return clazz != null && clazz.isPrimitive();
    }

    public static boolean isPrimitiveWrapperType(Class<?> clazz) {
        return clazz != null && WRAPPER_TYPES.contains(clazz);
    }

    public static boolean isComparableType(Class<?> clazz) {
        return BigDecimal.class.equals(clazz);
    }

    public static <T> T freshInstanceOf(Class<T> clazz) {
        Constructor<T> constructor;
        if (clazz == null) {
            return null;
        }
        try {
            constructor = clazz.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            logger.debug("Missing default constructor for type {}. Assuming standard default values for primitive properties.", (Object)clazz.getName());
            return null;
        }
        boolean accessibility = constructor.isAccessible();
        try {
            constructor.setAccessible(true);
            T t = constructor.newInstance(new Object[0]);
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            constructor.setAccessible(accessibility);
        }
    }

    public static Set<Class<?>> typesOf(Object ... values) {
        HashSet types = new HashSet(values.length);
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            if (value != null) {
                types.add(value.getClass());
            }
            ++n2;
        }
        return types;
    }

    public static boolean allAssignableFrom(Class<?> sharedType, Iterable<? extends Class<?>> types) {
        boolean matching = true;
        for (Class<?> type : types) {
            if (sharedType.isAssignableFrom(type)) continue;
            matching = false;
        }
        return matching;
    }

    public static Class<?> mostSpecificSharedType(Collection<Class<?>> types) {
        Collection<Class<?>> potentiallySharedTypes = Classes.superclassesOf(types);
        potentiallySharedTypes.addAll(types);
        TreeSet sharedTypes = new TreeSet(new ClassComparator());
        for (Class<?> potentiallySharedType : potentiallySharedTypes) {
            int matches = 0;
            for (Class<?> type : types) {
                if (!potentiallySharedType.isAssignableFrom(type)) continue;
                ++matches;
            }
            if (matches != types.size()) continue;
            sharedTypes.add(potentiallySharedType);
        }
        if (sharedTypes.isEmpty()) {
            return null;
        }
        return (Class)sharedTypes.iterator().next();
    }

    private static Collection<Class<?>> superclassesOf(Iterable<Class<?>> types) {
        HashSet superclasses = new HashSet();
        for (Class<?> type : types) {
            Class<?> superclass = type.getSuperclass();
            while (superclass != null && superclass != Object.class) {
                superclasses.add(superclass);
                superclass = superclass.getSuperclass();
            }
        }
        return superclasses;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassComparator
    implements Comparator<Class<?>>,
    Serializable {
        private static final long serialVersionUID = 56568941407903459L;

        private ClassComparator() {
        }

        @Override
        public int compare(Class<?> o1, Class<?> o2) {
            if (o1.isAssignableFrom(o2)) {
                return 1;
            }
            if (o2.isAssignableFrom(o1)) {
                return -1;
            }
            return 0;
        }
    }
}

