/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.inclusion;

import de.danielbechler.diff.category.CategoryResolver;
import de.danielbechler.diff.inclusion.Inclusion;
import de.danielbechler.diff.inclusion.InclusionResolver;
import de.danielbechler.diff.node.DiffNode;
import de.danielbechler.util.Assert;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class CategoryInclusionResolver
implements InclusionResolver {
    private final CategoryResolver categoryResolver;
    private final Map<String, Inclusion> categoryInclusions = new HashMap<String, Inclusion>();
    private boolean containsIncluded;
    private boolean containsExcluded;

    public CategoryInclusionResolver(CategoryResolver categoryResolver) {
        Assert.notNull(categoryResolver, "categoryResolver");
        this.categoryResolver = categoryResolver;
    }

    public Inclusion getInclusion(DiffNode node) {
        if (this.isInactive()) {
            return Inclusion.DEFAULT;
        }
        Set<String> categories = this.categoryResolver.resolveCategories(node);
        Inclusion resolvedInclusion = Inclusion.DEFAULT;
        for (String category : categories) {
            Inclusion configuredInclusion = this.categoryInclusions.get(category);
            if (configuredInclusion == Inclusion.EXCLUDED) {
                return Inclusion.EXCLUDED;
            }
            if (configuredInclusion != Inclusion.INCLUDED) continue;
            resolvedInclusion = Inclusion.INCLUDED;
        }
        return resolvedInclusion;
    }

    private boolean isInactive() {
        return !this.containsIncluded && !this.containsExcluded;
    }

    public boolean enablesStrictIncludeMode() {
        return this.containsIncluded;
    }

    public void setInclusion(String category, Inclusion inclusion) {
        this.categoryInclusions.put(category, inclusion);
        this.containsIncluded = this.categoryInclusions.containsValue((Object)Inclusion.INCLUDED);
        this.containsExcluded = this.categoryInclusions.containsValue((Object)Inclusion.EXCLUDED);
    }
}

