/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.selector;

import de.danielbechler.diff.identity.EqualsIdentityStrategy;
import de.danielbechler.diff.identity.IdentityStrategy;
import de.danielbechler.diff.selector.ElementSelector;
import de.danielbechler.util.Assert;
import de.danielbechler.util.Strings;

public final class CollectionItemElementSelector
extends ElementSelector {
    private final Object item;
    private final IdentityStrategy identityStrategy;

    public CollectionItemElementSelector(Object item) {
        this(item, EqualsIdentityStrategy.getInstance());
    }

    CollectionItemElementSelector(Object item, IdentityStrategy identityStrategy) {
        Assert.notNull(identityStrategy, "identityStrategy");
        this.item = item;
        this.identityStrategy = identityStrategy;
    }

    public CollectionItemElementSelector copyWithIdentityStrategy(IdentityStrategy identityStrategy) {
        return new CollectionItemElementSelector(this.item, identityStrategy);
    }

    @Deprecated
    public Object getItem() {
        return this.item;
    }

    public String toHumanReadableString() {
        return "[" + Strings.toSingleLineString(this.item) + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollectionItemElementSelector that = (CollectionItemElementSelector)o;
        return !(this.item != null ? !this.identityStrategy.equals(this.item, that.item) : that.item != null);
    }

    public int hashCode() {
        return 31;
    }
}

