/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.inclusion;

import de.danielbechler.diff.access.PropertyAwareAccessor;
import de.danielbechler.diff.inclusion.Inclusion;
import de.danielbechler.diff.inclusion.InclusionResolver;
import de.danielbechler.diff.instantiation.TypeInfo;
import de.danielbechler.diff.introspection.ObjectDiffProperty;
import de.danielbechler.diff.node.DiffNode;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TypePropertyAnnotationInclusionResolver
implements InclusionResolver {
    TypePropertyAnnotationInclusionResolver() {
    }

    @Override
    public boolean enablesStrictIncludeMode() {
        return false;
    }

    @Override
    public Inclusion getInclusion(DiffNode node) {
        ObjectDiffProperty propertyAnnotation = node.getPropertyAnnotation(ObjectDiffProperty.class);
        if (propertyAnnotation != null) {
            if (propertyAnnotation.inclusion() == Inclusion.INCLUDED || propertyAnnotation.inclusion() == Inclusion.EXCLUDED) {
                return propertyAnnotation.inclusion();
            }
            if (propertyAnnotation.excluded()) {
                return Inclusion.EXCLUDED;
            }
        } else if (TypePropertyAnnotationInclusionResolver.hasIncludedSibling(node)) {
            return Inclusion.EXCLUDED;
        }
        return Inclusion.DEFAULT;
    }

    private static boolean hasIncludedSibling(DiffNode node) {
        for (PropertyAwareAccessor accessor : TypePropertyAnnotationInclusionResolver.getSiblingAccessors(node)) {
            ObjectDiffProperty annotation = accessor.getReadMethodAnnotation(ObjectDiffProperty.class);
            if (annotation == null || annotation.inclusion() != Inclusion.INCLUDED) continue;
            return true;
        }
        return false;
    }

    private static Iterable<PropertyAwareAccessor> getSiblingAccessors(DiffNode node) {
        TypeInfo typeInfo;
        DiffNode parentNode = node.getParentNode();
        if (parentNode != null && (typeInfo = parentNode.getValueTypeInfo()) != null) {
            return typeInfo.getAccessors();
        }
        return Collections.emptyList();
    }
}

