/*
 * Decompiled with CFR 0.152.
 */
package de.hanbei.httpserver;

import com.sun.net.httpserver.HttpServer;
import de.hanbei.httpserver.MockHttpHandler;
import de.hanbei.httpserver.RequestProcessor;
import de.hanbei.httpserver.common.Method;
import de.hanbei.httpserver.common.Status;
import de.hanbei.httpserver.exceptions.ServerErrorException;
import de.hanbei.httpserver.request.Request;
import de.hanbei.httpserver.response.Response;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockHttpServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MockHttpServer.class);
    private final int port;
    private MockHttpHandler httpHandler;
    private HttpServer server;
    private boolean running;

    public MockHttpServer() {
        this(80);
    }

    public MockHttpServer(int port) {
        this.port = port;
        this.running = false;
        try {
            this.httpHandler = new MockHttpHandler();
            this.server = HttpServer.create(new InetSocketAddress(this.port), 100);
            this.server.createContext("/", this.httpHandler);
        }
        catch (IOException e) {
            throw new ServerErrorException("Could not start the server.", e);
        }
    }

    public static void main(String[] args) throws IOException {
        MockHttpServer server = new MockHttpServer(7001);
        server.httpHandler.addRequestProcessor(Method.POST, URI.create("post"), new RequestProcessor(){

            @Override
            public Response process(Request request) {
                if ("Test".equals(request.getContent().getContentAsString())) {
                    return Response.ok().build();
                }
                return Response.status(Status.UNAUTHORIZED).build();
            }
        });
        server.addResponse(Method.GET, URI.create("test"), Response.notFound().build());
        server.start();
        System.in.read();
        server.stop();
    }

    public void start() {
        this.server.start();
        this.running = true;
    }

    public void stop() {
        this.server.stop(1);
        this.running = false;
    }

    public boolean isTimeoutSet() {
        return this.httpHandler.isTimeoutSet();
    }

    public void setTimeout(boolean shouldTimeout) {
        this.httpHandler.setTimeout(shouldTimeout);
    }

    public int getPort() {
        return this.port;
    }

    public boolean isRunning() {
        return this.running;
    }

    public Response getDefaultResponse() {
        return this.httpHandler.getDefaultResponse();
    }

    public void setDefaultResponse(Response defaultResponse) {
        this.httpHandler.setDefaultResponse(defaultResponse);
    }

    public void addResponse(URI uri, Response response) {
        this.httpHandler.addResponse(Method.GET, uri, response);
    }

    public void addResponse(Method method, URI uri, Response response) {
        this.httpHandler.addResponse(method, uri, response);
    }

    public void addRequestProcessor(Method method, URI uri, RequestProcessor processor) {
        this.httpHandler.addRequestProcessor(method, uri, processor);
    }
}

