/*
 * Decompiled with CFR 0.152.
 */
package de.hanbei.httpserver.response;

import de.hanbei.httpserver.common.HTTPVersion;
import de.hanbei.httpserver.common.Status;
import de.hanbei.httpserver.exceptions.ContentException;
import de.hanbei.httpserver.response.Response;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.io.Charsets;

public class ResponseBuilder {
    private static final String TEXT_PLAIN = "text/plain";
    private final SimpleDateFormat dateFormat;
    private Response response;

    ResponseBuilder(Response response) {
        this.response = response;
        this.dateFormat = new SimpleDateFormat("EEE, dd MMM yyyyy HH:mm:ss z");
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public Response build() {
        return this.response;
    }

    public ResponseBuilder status(int status) {
        this.response.setStatus(new Status(status));
        return this;
    }

    public ResponseBuilder status(Status status) {
        this.response.setStatus(status);
        return this;
    }

    public ResponseBuilder version(HTTPVersion version) {
        this.response.setHttpVersion(version);
        return this;
    }

    public ResponseBuilder content(Object content) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOut = new ObjectOutputStream(bytes);
            objectOut.writeObject(content);
        }
        catch (IOException e) {
            throw new ContentException(e);
        }
        this.content(bytes.toByteArray());
        return this;
    }

    public ResponseBuilder content(String content) {
        this.content(content, Charsets.UTF_8);
        return this;
    }

    public ResponseBuilder content(String content, Charset charset) {
        this.content(content.getBytes(charset));
        this.response.getContent().setCharset(charset.name());
        this.response.getContent().setString(true);
        return this;
    }

    public ResponseBuilder content(byte[] content) {
        this.response.getContent().setContent(content);
        this.response.getContent().setLength(content.length);
        this.response.getContent().setString(false);
        return this;
    }

    public ResponseBuilder expires(Date expires) {
        this.response.getHeader().addParameter("Expires", this.dateFormat.format(expires));
        return this;
    }

    public ResponseBuilder header(String name, String value) {
        this.response.getHeader().addParameter(name, value);
        return this;
    }

    public ResponseBuilder language(String language) {
        this.response.getHeader().addParameter("Accept-Language", language);
        return this;
    }

    public ResponseBuilder lastModified(Date lastModified) {
        this.response.getHeader().addParameter("Last-Modified", this.dateFormat.format(lastModified));
        return this;
    }

    public ResponseBuilder location(URI location) {
        this.response.getContent().setLocation(location);
        return this;
    }

    public ResponseBuilder type(String type) {
        this.response.getContent().setMimetype(type);
        return this;
    }
}

