/*
 * Decompiled with CFR 0.152.
 */
package de.marhali.json5;

import de.marhali.json5.Json5Element;
import de.marhali.json5.Json5Options;
import de.marhali.json5.Json5OptionsBuilder;
import de.marhali.json5.stream.Json5Lexer;
import de.marhali.json5.stream.Json5Parser;
import de.marhali.json5.stream.Json5Writer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Objects;
import java.util.function.Function;

public final class Json5 {
    private final Json5Options options;

    public static Json5 builder(Function<Json5OptionsBuilder, Json5Options> builder) {
        return new Json5(builder.apply(new Json5OptionsBuilder()));
    }

    public Json5(Json5Options options) {
        this.options = Objects.requireNonNull(options);
    }

    public Json5() {
        this(Json5Options.DEFAULT);
    }

    public Json5Element parse(InputStream in) {
        Objects.requireNonNull(in);
        return this.parse(new InputStreamReader(in));
    }

    public Json5Element parse(Reader reader) {
        Objects.requireNonNull(reader);
        Json5Lexer lexer = new Json5Lexer(reader, this.options);
        return Json5Parser.parse(lexer);
    }

    public Json5Element parse(String jsonString) {
        Objects.requireNonNull(jsonString);
        StringReader reader = new StringReader(jsonString);
        Json5Element element = this.parse(reader);
        reader.close();
        return element;
    }

    public void serialize(Json5Element element, OutputStream out) throws IOException {
        Objects.requireNonNull(element);
        Objects.requireNonNull(out);
        this.serialize(element, new OutputStreamWriter(out));
    }

    public void serialize(Json5Element element, Writer writer) throws IOException {
        Objects.requireNonNull(element);
        Objects.requireNonNull(writer);
        Json5Writer json5Writer = new Json5Writer(this.options, writer);
        json5Writer.write(element);
    }

    public String serialize(Json5Element element) throws IOException {
        Objects.requireNonNull(element);
        StringWriter writer = new StringWriter();
        this.serialize(element, writer);
        writer.close();
        return writer.toString();
    }
}

