/*
 * Decompiled with CFR 0.152.
 */
package de.marhali.json5;

import de.marhali.json5.Json5Array;
import de.marhali.json5.Json5Null;
import de.marhali.json5.Json5Object;
import de.marhali.json5.Json5Options;
import de.marhali.json5.Json5Primitive;
import de.marhali.json5.stream.Json5Writer;
import java.io.IOException;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;

public abstract class Json5Element {
    public abstract Json5Element deepCopy();

    public boolean isJsonArray() {
        return this instanceof Json5Array;
    }

    public boolean isJsonObject() {
        return this instanceof Json5Object;
    }

    public boolean isJsonPrimitive() {
        return this instanceof Json5Primitive;
    }

    public boolean isJsonNull() {
        return this instanceof Json5Null;
    }

    public Json5Object getAsJsonObject() {
        if (this.isJsonObject()) {
            return (Json5Object)this;
        }
        throw new IllegalStateException("Not a JSON Object: " + this);
    }

    public Json5Array getAsJsonArray() {
        if (this.isJsonArray()) {
            return (Json5Array)this;
        }
        throw new IllegalStateException("Not a JSON Array: " + this);
    }

    public Json5Primitive getAsJsonPrimitive() {
        if (this.isJsonPrimitive()) {
            return (Json5Primitive)this;
        }
        throw new IllegalStateException("Not a JSON Primitive: " + this);
    }

    public Json5Null getAsJsonNull() {
        if (this.isJsonNull()) {
            return (Json5Null)this;
        }
        throw new IllegalStateException("Not a JSON Null: " + this);
    }

    public boolean getAsBoolean() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName());
    }

    public Number getAsNumber() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName());
    }

    public String getAsString() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName());
    }

    public double getAsDouble() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName());
    }

    public float getAsFloat() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName());
    }

    public long getAsLong() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName());
    }

    public int getAsInt() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName());
    }

    public byte getAsByte() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName());
    }

    public BigDecimal getAsBigDecimal() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName());
    }

    public BigInteger getAsBigInteger() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName());
    }

    public short getAsShort() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName());
    }

    public String toString() {
        return this.toString(Json5Options.DEFAULT);
    }

    public String toString(Json5Options options) {
        Objects.requireNonNull(options);
        try {
            StringWriter stringWriter = new StringWriter();
            Json5Writer json5Writer = new Json5Writer(options, stringWriter);
            json5Writer.write(this);
            return stringWriter.toString();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

