/*
 * Decompiled with CFR 0.152.
 */
package de.marhali.json5;

import de.marhali.json5.Json5Array;
import de.marhali.json5.Json5Boolean;
import de.marhali.json5.Json5Element;
import de.marhali.json5.Json5Null;
import de.marhali.json5.Json5Number;
import de.marhali.json5.Json5Primitive;
import de.marhali.json5.Json5String;
import de.marhali.json5.internal.LinkedTreeMap;
import java.util.Map;
import java.util.Set;

public final class Json5Object
extends Json5Element {
    private final LinkedTreeMap<String, Json5Element> members = new LinkedTreeMap();

    @Override
    public Json5Object deepCopy() {
        Json5Object result = new Json5Object();
        for (Map.Entry<String, Json5Element> entry : this.members.entrySet()) {
            result.add(entry.getKey(), entry.getValue().deepCopy());
        }
        return result;
    }

    public void add(String property, Json5Element value) {
        this.members.put(property, value == null ? Json5Null.INSTANCE : value);
    }

    public Json5Element remove(String property) {
        return this.members.remove(property);
    }

    public void addProperty(String property, String value) {
        this.add(property, value == null ? Json5Null.INSTANCE : new Json5String(value));
    }

    public void addProperty(String property, Number value) {
        this.add(property, value == null ? Json5Null.INSTANCE : new Json5Number(value));
    }

    public void addProperty(String property, Boolean value) {
        this.add(property, value == null ? Json5Null.INSTANCE : new Json5Boolean(value));
    }

    public void addProperty(String property, Character value) {
        this.add(property, value == null ? Json5Null.INSTANCE : new Json5String(value.toString()));
    }

    public Set<Map.Entry<String, Json5Element>> entrySet() {
        return this.members.entrySet();
    }

    public Set<String> keySet() {
        return this.members.keySet();
    }

    public int size() {
        return this.members.size();
    }

    public boolean has(String memberName) {
        return this.members.containsKey(memberName);
    }

    public Json5Element get(String memberName) {
        return this.members.get(memberName);
    }

    public Json5Primitive getAsJson5Primitive(String memberName) {
        return (Json5Primitive)this.members.get(memberName);
    }

    public Json5Array getAsJson5Array(String memberName) {
        return (Json5Array)this.members.get(memberName);
    }

    public Json5Object getAsJson5Object(String memberName) {
        return (Json5Object)this.members.get(memberName);
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Json5Object && ((Json5Object)o).members.equals(this.members);
    }

    public int hashCode() {
        return this.members.hashCode();
    }
}

