/*
 * Decompiled with CFR 0.152.
 */
package de.marhali.json5.stream;

import de.marhali.json5.Json5Array;
import de.marhali.json5.Json5Element;
import de.marhali.json5.Json5Object;
import de.marhali.json5.exception.Json5Exception;
import de.marhali.json5.stream.Json5Lexer;
import java.util.Objects;

public final class Json5Parser {
    private Json5Parser() {
    }

    public static Json5Element parse(Json5Lexer lexer) {
        Objects.requireNonNull(lexer);
        switch (lexer.nextClean()) {
            case '{': {
                lexer.back();
                return Json5Parser.parseObject(lexer);
            }
            case '[': {
                lexer.back();
                return Json5Parser.parseArray(lexer);
            }
            case '\u0000': {
                return null;
            }
        }
        throw lexer.syntaxError("Unknown or unexpected control character");
    }

    public static Json5Object parseObject(Json5Lexer lexer) {
        char control;
        Objects.requireNonNull(lexer);
        if (lexer.nextClean() != '{') {
            throw lexer.syntaxError("A json object must begin with '{'");
        }
        Json5Object object = new Json5Object();
        do {
            control = lexer.nextClean();
            switch (control) {
                case '\u0000': {
                    throw lexer.syntaxError("A json object must end with '}'");
                }
                case '}': {
                    return object;
                }
            }
            lexer.back();
            String key = lexer.nextMemberName();
            if (object.has(key)) {
                throw new Json5Exception("Duplicate key " + key);
            }
            if (lexer.nextClean() != ':') {
                throw lexer.syntaxError("Expected ':' after a key, got '" + control + "' instead");
            }
            object.add(key, lexer.nextValue());
            control = lexer.nextClean();
            if (control != '}') continue;
            return object;
        } while (control == ',');
        throw lexer.syntaxError("Expected ',' or '}' after value, got '" + control + "' instead");
    }

    public static Json5Array parseArray(Json5Lexer lexer) {
        char control;
        Objects.requireNonNull(lexer);
        if (lexer.nextClean() != '[') {
            throw lexer.syntaxError("A json array must begin with '['");
        }
        Json5Array array = new Json5Array();
        do {
            control = lexer.nextClean();
            switch (control) {
                case '\u0000': {
                    throw lexer.syntaxError("A json array must end with ']'");
                }
                case ']': {
                    return array;
                }
            }
            lexer.back();
            array.add(lexer.nextValue());
            control = lexer.nextClean();
            if (control != ']') continue;
            return array;
        } while (control == ',');
        throw lexer.syntaxError("Expected ',' or ']' after value, got '" + control + "' instead");
    }
}

