/*
 * Decompiled with CFR 0.152.
 */
package de.osshangar.plugin.classloader;

import java.util.Map;
import lombok.NonNull;

public class PluginClassLoader
extends ClassLoader {
    private final Map<String, byte[]> classFiles;

    public PluginClassLoader(@NonNull Map<String, byte[]> classesFiles) {
        super(PluginClassLoader.class.getClassLoader());
        if (classesFiles == null) {
            throw new NullPointerException("classesFiles is marked non-null but is null");
        }
        this.classFiles = classesFiles;
    }

    @Override
    public Class<?> findClass(@NonNull String fullQualifiedClassName) throws ClassNotFoundException {
        if (fullQualifiedClassName == null) {
            throw new NullPointerException("fullQualifiedClassName is marked non-null but is null");
        }
        if (!this.classFiles.containsKey(fullQualifiedClassName)) {
            throw new ClassNotFoundException(String.format("Did not find class '%s'", fullQualifiedClassName));
        }
        return this.defineClass(fullQualifiedClassName, this.classFiles.get(fullQualifiedClassName), 0, this.classFiles.get(fullQualifiedClassName).length);
    }

    @Override
    public Class<?> loadClass(String fullQualifiedClassName) throws ClassNotFoundException {
        if (this.classFiles.containsKey(fullQualifiedClassName)) {
            return this.findClass(fullQualifiedClassName);
        }
        ClassLoader defaultLoader = Thread.currentThread().getContextClassLoader();
        Class<?> loadedClass = defaultLoader.loadClass(fullQualifiedClassName);
        return loadedClass;
    }
}

