/*
 * Decompiled with CFR 0.152.
 */
package de.osshangar.plugin.content;

import de.osshangar.plugin.exception.FileFormatException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;

public class Inspector {
    private String pluginClassName;
    private String pluginClassSpecificationFile;
    private final Map<String, byte[]> entries = new HashMap<String, byte[]>();
    private final Map<String, byte[]> classFiles = new HashMap<String, byte[]>();

    private void setClassFiles() {
        this.entries.entrySet().stream().filter(file -> ((String)file.getKey()).endsWith(".class")).forEach(file -> {
            String className = ((String)file.getKey()).replace(".class", "").replace("/", ".");
            this.classFiles.put(className, (byte[])file.getValue());
        });
    }

    private void setPluginInterface(@NonNull Class<?> interfaceClass) throws FileNotFoundException {
        if (interfaceClass == null) {
            throw new NullPointerException("interfaceClass is marked non-null but is null");
        }
        String pluginClassSpecificationFile = String.format("META-INF/services/%s", interfaceClass.getCanonicalName());
        if (!this.entries.containsKey(pluginClassSpecificationFile)) {
            throw new FileNotFoundException(pluginClassSpecificationFile);
        }
        this.pluginClassSpecificationFile = pluginClassSpecificationFile;
    }

    private void setPluginClassName() throws FileFormatException {
        assert (this.pluginClassSpecificationFile != null);
        assert (this.entries.containsKey(this.pluginClassSpecificationFile));
        List pluginClassSpecificationFileLines = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.entries.get(this.pluginClassSpecificationFile)))).lines().collect(Collectors.toList());
        if (pluginClassSpecificationFileLines.isEmpty()) {
            throw new FileFormatException(String.format("File must contain the name of the class to be loaded as plugin: %s", this.pluginClassSpecificationFile));
        }
        if (pluginClassSpecificationFileLines.size() > 1) {
            throw new FileFormatException(String.format("File must not specify multiple classes to be loaded as plugins: %s", this.pluginClassSpecificationFile));
        }
        String pluginClassName = ((String)pluginClassSpecificationFileLines.get(0)).trim();
        if (pluginClassName.isEmpty()) {
            throw new FileFormatException(String.format("File must contain the name of the class to be loaded as plugin: %s", this.pluginClassSpecificationFile));
        }
        this.pluginClassName = pluginClassName;
    }

    public static Inspector inspect(@NonNull JarInputStream jarInputStream, @NonNull Class<?> interfaceClass) throws IOException, FileFormatException {
        if (jarInputStream == null) {
            throw new NullPointerException("jarInputStream is marked non-null but is null");
        }
        if (interfaceClass == null) {
            throw new NullPointerException("interfaceClass is marked non-null but is null");
        }
        Inspector inspector = new Inspector();
        JarEntry jarEntry = jarInputStream.getNextJarEntry();
        while (jarEntry != null) {
            if (!jarEntry.isDirectory()) {
                inspector.entries.put(jarEntry.getName(), IOUtils.toByteArray((InputStream)jarInputStream));
            }
            jarEntry = jarInputStream.getNextJarEntry();
        }
        inspector.setClassFiles();
        inspector.setPluginInterface(interfaceClass);
        inspector.setPluginClassName();
        return inspector;
    }

    public String getPluginClassName() {
        return this.pluginClassName;
    }

    public String getPluginClassSpecificationFile() {
        return this.pluginClassSpecificationFile;
    }

    public Map<String, byte[]> getEntries() {
        return this.entries;
    }

    public Map<String, byte[]> getClassFiles() {
        return this.classFiles;
    }
}

