/*
 * Decompiled with CFR 0.152.
 */
package de.osshangar.plugin;

import java.util.Arrays;
import lombok.NonNull;

public class Arguments {
    @NonNull
    private final Class<?>[] constructor;
    @NonNull
    private final Object[] arguments;

    Arguments(@NonNull Class<?>[] constructor, @NonNull Object[] arguments) {
        if (constructor == null) {
            throw new NullPointerException("constructor is marked non-null but is null");
        }
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        this.constructor = constructor;
        this.arguments = arguments;
    }

    public static ArgumentsBuilder builder() {
        return new ArgumentsBuilder();
    }

    @NonNull
    public Class<?>[] getConstructor() {
        return this.constructor;
    }

    @NonNull
    public Object[] getArguments() {
        return this.arguments;
    }

    public static class ArgumentsBuilder {
        private Class<?>[] constructor;
        private Object[] arguments;

        ArgumentsBuilder() {
        }

        public ArgumentsBuilder constructor(@NonNull Class<?>[] constructor) {
            if (constructor == null) {
                throw new NullPointerException("constructor is marked non-null but is null");
            }
            this.constructor = constructor;
            return this;
        }

        public ArgumentsBuilder arguments(@NonNull Object[] arguments) {
            if (arguments == null) {
                throw new NullPointerException("arguments is marked non-null but is null");
            }
            this.arguments = arguments;
            return this;
        }

        public Arguments build() {
            return new Arguments(this.constructor, this.arguments);
        }

        public String toString() {
            return "Arguments.ArgumentsBuilder(constructor=" + Arrays.deepToString(this.constructor) + ", arguments=" + Arrays.deepToString(this.arguments) + ")";
        }
    }
}

