/*
 * Decompiled with CFR 0.152.
 */
package de.osshangar.plugin;

import de.osshangar.plugin.Arguments;
import de.osshangar.plugin.classloader.PluginClassLoader;
import de.osshangar.plugin.content.Inspector;
import de.osshangar.plugin.exception.FileFormatException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarInputStream;
import lombok.NonNull;

public class Plugin<T> {
    @NonNull
    private final Class<T> interfaceClass;
    private PluginClassLoader classLoader = new PluginClassLoader(new HashMap<String, byte[]>(), new HashMap<String, byte[]>());

    public T load(JarInputStream jarInputStream) throws FileFormatException, IOException, ClassNotFoundException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        return this.load(jarInputStream, null);
    }

    public T load(Map<String, byte[]> classFiles, Map<String, byte[]> resources, String classToLoadName) throws ClassNotFoundException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        return this.load(classFiles, resources, classToLoadName, null);
    }

    public T load(JarInputStream jarInputStream, Arguments constructorArguments) throws FileFormatException, IOException, ClassNotFoundException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        Inspector inspector = Inspector.inspect(jarInputStream, this.interfaceClass);
        return this.load(inspector.getClassFiles(), inspector.getResources(), inspector.getPluginClassName(), constructorArguments);
    }

    public T load(Map<String, byte[]> classFiles, Map<String, byte[]> resources, String classToLoadName, Arguments constructorArguments) throws ClassNotFoundException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        this.classLoader = new PluginClassLoader(classFiles, resources);
        return this.createInstance(this.classLoader, classToLoadName, constructorArguments);
    }

    private T createInstance(PluginClassLoader classLoader, String pluginClassName, Arguments constructorArguments) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Class<?> pluginClass = classLoader.findClass(pluginClassName);
        if (!this.interfaceClass.isAssignableFrom(pluginClass)) {
            throw new ClassCastException(String.format("The compiled class is no implementation or subclass of %s", this.interfaceClass.getCanonicalName()));
        }
        Class[] signature = new Class[]{};
        Object[] arguments = new Object[]{};
        if (constructorArguments != null) {
            signature = constructorArguments.getConstructor();
            arguments = constructorArguments.getArguments();
        }
        Constructor<?> constructor = pluginClass.getConstructor(signature);
        Object instance = constructor.newInstance(arguments);
        return (T)instance;
    }

    public Plugin(@NonNull Class<T> interfaceClass) {
        if (interfaceClass == null) {
            throw new NullPointerException("interfaceClass is marked non-null but is null");
        }
        this.interfaceClass = interfaceClass;
    }

    public PluginClassLoader getClassLoader() {
        return this.classLoader;
    }
}

