/*
 * Decompiled with CFR 0.152.
 */
package de.osshangar.plugin.classloader;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import lombok.NonNull;

public class PluginClassLoader
extends ClassLoader {
    private final Map<String, byte[]> byteCodes;
    private final Map<String, byte[]> resources;

    public PluginClassLoader(@NonNull Map<String, byte[]> classesFiles, @NonNull Map<String, byte[]> resources) {
        super(PluginClassLoader.class.getClassLoader());
        if (classesFiles == null) {
            throw new NullPointerException("classesFiles is marked non-null but is null");
        }
        if (resources == null) {
            throw new NullPointerException("resources is marked non-null but is null");
        }
        this.byteCodes = classesFiles;
        this.resources = resources;
    }

    @Override
    public Class<?> findClass(@NonNull String fullQualifiedClassName) throws ClassNotFoundException {
        if (fullQualifiedClassName == null) {
            throw new NullPointerException("fullQualifiedClassName is marked non-null but is null");
        }
        if (!this.byteCodes.containsKey(fullQualifiedClassName)) {
            throw new ClassNotFoundException(String.format("Did not find class '%s'", fullQualifiedClassName));
        }
        return this.defineClass(fullQualifiedClassName, this.byteCodes.get(fullQualifiedClassName), 0, this.byteCodes.get(fullQualifiedClassName).length);
    }

    @Override
    public Class<?> loadClass(@NonNull String fullQualifiedClassName) throws ClassNotFoundException {
        if (fullQualifiedClassName == null) {
            throw new NullPointerException("fullQualifiedClassName is marked non-null but is null");
        }
        if (this.byteCodes.containsKey(fullQualifiedClassName)) {
            return this.findClass(fullQualifiedClassName);
        }
        ClassLoader defaultLoader = Thread.currentThread().getContextClassLoader();
        return defaultLoader.loadClass(fullQualifiedClassName);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream inputStream;
        block9: {
            File file = new File(name);
            if (!file.exists() && this.resources.containsKey(name)) {
                return new ByteArrayInputStream(this.resources.get(name));
            }
            InputStream inputStream2 = super.getResourceAsStream(name);
            try {
                inputStream = inputStream2;
                if (inputStream2 == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream2 != null) {
                        try {
                            inputStream2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            inputStream2.close();
        }
        return inputStream;
    }

    public Map<String, byte[]> getByteCodes() {
        return this.byteCodes;
    }
}

