/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.genetic;

import de.sfuhrm.genetic.AbstractHypothesis;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;

public class GeneticAlgorithm<H extends AbstractHypothesis<H>> {
    private static final Random RANDOM = new Random();
    private double crossOverRate;
    private double mutationRate;
    private int generationSize;

    public GeneticAlgorithm(double inCrossOverRate, double inMutationRate, int inGenerationSize) {
        if (inCrossOverRate < 0.0 || inCrossOverRate > 1.0) {
            throw new IllegalArgumentException("Cross over rate not between 0 and 1: " + inCrossOverRate);
        }
        if (inMutationRate < 0.0 || inMutationRate > 1.0) {
            throw new IllegalArgumentException("Mutation rate not between 0 and 1: " + inMutationRate);
        }
        if (inGenerationSize < 2) {
            throw new IllegalArgumentException("Generation size is < 2: " + inMutationRate);
        }
        this.crossOverRate = inCrossOverRate;
        this.mutationRate = inMutationRate;
        this.generationSize = inGenerationSize;
    }

    protected void select(List<H> population, Collection<H> selectedList) {
        int selectSize = (int)((1.0 - this.crossOverRate) * (double)population.size());
        while (selectedList.size() < selectSize) {
            this.probabilisticSelect(population, selectedList, true);
        }
    }

    protected void crossover(List<H> population, Collection<H> selectedSet) {
        int crossOverSize = (int)(this.crossOverRate * (double)population.size());
        for (int i = 0; i < crossOverSize / 2; ++i) {
            H first = this.probabilisticSelect(population, Collections.emptyList(), false);
            H second = this.probabilisticSelect(population, Collections.emptyList(), false);
            selectedSet.addAll(((AbstractHypothesis)first).crossOver(second));
        }
    }

    protected void mutate(List<H> selectedSet) {
        int mutationSize = (int)(this.mutationRate * (double)selectedSet.size());
        for (int i = 0; i < mutationSize; ++i) {
            int index = RANDOM.nextInt(selectedSet.size());
            AbstractHypothesis current = (AbstractHypothesis)selectedSet.get(index);
            current.mutate();
        }
    }

    protected H probabilisticSelect(List<H> population, Collection<H> targetList, boolean addToTargetList) {
        AbstractHypothesis result = (AbstractHypothesis)population.get(0);
        double sumOfProbabilities = population.stream().mapToDouble(AbstractHypothesis::getProbability).sum();
        double randomPoint = RANDOM.nextDouble();
        double inflatedPoint = randomPoint * sumOfProbabilities;
        double soFar = 0.0;
        for (int i = 0; i < population.size() && soFar < inflatedPoint; soFar += result.getProbability(), ++i) {
            result = (AbstractHypothesis)population.get(i);
        }
        if (addToTargetList) {
            targetList.add(result);
        }
        return (H)result;
    }

    protected Optional<H> max(Collection<H> in) {
        return in.stream().sorted(Comparator.comparingDouble(h -> h.getFitness())).skip(in.size() - 1).findFirst();
    }

    public Optional<H> findMaximum(Function<H, Boolean> loopCondition, Supplier<H> hypothesisSupplier) {
        ArrayList<Object> population = new ArrayList<Object>();
        ArrayList selected = new ArrayList();
        Optional<Object> max = Optional.empty();
        for (int i = 0; i < this.generationSize; ++i) {
            population.add(((AbstractHypothesis)hypothesisSupplier.get()).randomInit());
        }
        do {
            population.forEach(h -> h.setFitness(h.calculateFitness()));
            double sumFitness = population.stream().mapToDouble(h -> h.getFitness()).sum();
            population.forEach(h -> h.setProbability(h.getFitness() / sumFitness));
            Optional curMax = this.max(population);
            if (curMax.isPresent()) {
                max = max.isPresent() ? this.max(Arrays.asList((AbstractHypothesis)curMax.get(), (AbstractHypothesis)max.get())) : curMax;
            }
            selected.clear();
            this.select(population, selected);
            this.crossover(population, selected);
            population.clear();
            population.addAll(selected);
            this.mutate(population);
        } while (max.isPresent() && loopCondition.apply((AbstractHypothesis)max.get()).booleanValue());
        return max;
    }

    public double getCrossOverRate() {
        return this.crossOverRate;
    }

    public void setCrossOverRate(double crossOverRate) {
        this.crossOverRate = crossOverRate;
    }

    public double getMutationRate() {
        return this.mutationRate;
    }

    public void setMutationRate(double mutationRate) {
        this.mutationRate = mutationRate;
    }

    public int getGenerationSize() {
        return this.generationSize;
    }

    public void setGenerationSize(int generationSize) {
        this.generationSize = generationSize;
    }
}

