/*
 * Decompiled with CFR 0.152.
 */
package dev.alexengrig.util.lambda;

import java.util.Objects;

@FunctionalInterface
public interface TerPredicate<F, S, T> {
    public boolean test(F var1, S var2, T var3);

    default public TerPredicate<F, S, T> and(TerPredicate<? super F, ? super S, ? super T> other) {
        Objects.requireNonNull(other, "The other-predicate must not be null");
        return (first, second, third) -> this.test(first, second, third) && other.test(first, second, third);
    }

    default public TerPredicate<F, S, T> negate() {
        return (first, second, third) -> !this.test(first, second, third);
    }

    default public TerPredicate<F, S, T> or(TerPredicate<? super F, ? super S, ? super T> other) {
        Objects.requireNonNull(other, "The other-predicate must not be null");
        return (first, second, third) -> this.test(first, second, third) || other.test(first, second, third);
    }
}

