/*
 * Decompiled with CFR 0.152.
 */
package dev.alexengrig.util.lambda;

import dev.alexengrig.util.lambda.TerPredicate;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;

public final class PredicateCurrying {
    private PredicateCurrying() {
    }

    public static <F> BooleanSupplier all(Predicate<F> predicate, F first) {
        Objects.requireNonNull(predicate, "The predicate must not be null");
        return () -> predicate.test(first);
    }

    public static <F, S> Function<F, Predicate<S>> left2(BiPredicate<F, S> biPredicate) {
        Objects.requireNonNull(biPredicate, "The bi-predicate must not be null");
        return first -> second -> biPredicate.test(first, second);
    }

    public static <F, S> Predicate<S> left2(BiPredicate<F, S> biPredicate, F first) {
        Objects.requireNonNull(biPredicate, "The bi-predicate must not be null");
        return second -> biPredicate.test(first, second);
    }

    public static <F, S> BooleanSupplier all2(BiPredicate<F, S> biPredicate, F first, S second) {
        Objects.requireNonNull(biPredicate, "The bi-predicate must not be null");
        return () -> biPredicate.test(first, second);
    }

    public static <F, S, T> Function<F, Function<S, Predicate<T>>> left3(TerPredicate<F, S, T> terPredicate) {
        Objects.requireNonNull(terPredicate, "The ter-predicate must not be null");
        return first -> second -> third -> terPredicate.test(first, second, third);
    }

    public static <F, S, T> Function<S, Predicate<T>> left3(TerPredicate<F, S, T> terPredicate, F first) {
        Objects.requireNonNull(terPredicate, "The ter-predicate must not be null");
        return second -> third -> terPredicate.test(first, second, third);
    }

    public static <F, S, T> Predicate<T> left3(TerPredicate<F, S, T> terPredicate, F first, S second) {
        Objects.requireNonNull(terPredicate, "The ter-predicate must not be null");
        return third -> terPredicate.test(first, second, third);
    }

    public static <F, S, T> BooleanSupplier all3(TerPredicate<F, S, T> terPredicate, F first, S second, T third) {
        Objects.requireNonNull(terPredicate, "The ter-predicate must not be null");
        return () -> terPredicate.test(first, second, third);
    }

    public static <F, S, T> Function<F, Predicate<T>> leftMiddle3(TerPredicate<F, S, T> terPredicate, S second) {
        Objects.requireNonNull(terPredicate, "The ter-predicate must not be null");
        return first -> third -> terPredicate.test(first, second, third);
    }

    public static <F, S, T> Predicate<S> middle3(TerPredicate<F, S, T> terPredicate, F first, T third) {
        Objects.requireNonNull(terPredicate, "The ter-predicate must not be null");
        return second -> terPredicate.test(first, second, third);
    }

    public static <F, S, T> Function<T, Predicate<F>> rightMiddle3(TerPredicate<F, S, T> terPredicate, S second) {
        Objects.requireNonNull(terPredicate, "The ter-predicate must not be null");
        return third -> first -> terPredicate.test(first, second, third);
    }

    public static <F, S> Function<S, Predicate<F>> right2(BiPredicate<F, S> biPredicate) {
        Objects.requireNonNull(biPredicate, "The bi-predicate must not be null");
        return second -> first -> biPredicate.test(first, second);
    }

    public static <F, S> Predicate<F> right2(BiPredicate<F, S> biPredicate, S second) {
        Objects.requireNonNull(biPredicate, "The bi-predicate must not be null");
        return first -> biPredicate.test(first, second);
    }

    public static <F, S, T> Function<T, Function<S, Predicate<F>>> right3(TerPredicate<F, S, T> terPredicate) {
        Objects.requireNonNull(terPredicate, "The ter-predicate must not be null");
        return third -> second -> first -> terPredicate.test(first, second, third);
    }

    public static <F, S, T> Function<S, Predicate<F>> right3(TerPredicate<F, S, T> terPredicate, T third) {
        Objects.requireNonNull(terPredicate, "The ter-predicate must not be null");
        return second -> first -> terPredicate.test(first, second, third);
    }

    public static <F, S, T> Predicate<F> right3(TerPredicate<F, S, T> terPredicate, S second, T third) {
        Objects.requireNonNull(terPredicate, "The ter-predicate must not be null");
        return first -> terPredicate.test(first, second, third);
    }

    public static <F, S, T> BiPredicate<S, T> biLeft3(TerPredicate<F, S, T> terPredicate, F first) {
        Objects.requireNonNull(terPredicate, "The ter-predicate must not be null");
        return (second, third) -> terPredicate.test(first, second, third);
    }

    public static <F, S, T> BiPredicate<F, T> biMiddle3(TerPredicate<F, S, T> terPredicate, S second) {
        Objects.requireNonNull(terPredicate, "The ter-predicate must not be null");
        return (first, third) -> terPredicate.test(first, second, third);
    }

    public static <F, S, T> BiPredicate<F, S> biRight3(TerPredicate<F, S, T> terPredicate, T third) {
        Objects.requireNonNull(terPredicate, "The ter-predicate must not be null");
        return (first, second) -> terPredicate.test(first, second, third);
    }
}

