/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator;

import com.steadystate.css.parser.Token;
import dev.amp.validator.Context;
import dev.amp.validator.ParsedTagSpec;
import dev.amp.validator.ParsedUrlSpec;
import dev.amp.validator.UrlErrorInStylesheetAdapter;
import dev.amp.validator.ValidatorProtos;
import dev.amp.validator.css.CssParser;
import dev.amp.validator.css.CssParsingConfig;
import dev.amp.validator.css.CssTokenUtil;
import dev.amp.validator.css.CssValidationException;
import dev.amp.validator.css.Declaration;
import dev.amp.validator.css.ErrorToken;
import dev.amp.validator.css.ParsedCssUrl;
import dev.amp.validator.css.ParsedDocCssSpec;
import dev.amp.validator.css.Stylesheet;
import dev.amp.validator.exception.TagValidationException;
import dev.amp.validator.utils.AttributeSpecUtils;
import dev.amp.validator.utils.ByteUtils;
import dev.amp.validator.utils.CssSpecUtils;
import dev.amp.validator.utils.TagSpecUtils;
import dev.amp.validator.utils.UrlUtils;
import dev.amp.validator.visitor.InvalidDeclVisitor;
import dev.amp.validator.visitor.InvalidRuleVisitor;
import dev.amp.validator.visitor.MediaQueryVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.xml.sax.Locator;

public class CdataMatcher {
    private ParsedTagSpec parsedTagSpec;
    private Locator lineCol;
    private static final Pattern WHITE_SPACE_CHARACTER_PATTERN = Pattern.compile("^\\s*$");
    private static final int CDATA_MAX_BYTES = -2;

    public CdataMatcher(@Nonnull ParsedTagSpec parsedTagSpec, @Nonnull Locator lineCol) {
        this.parsedTagSpec = parsedTagSpec;
        this.lineCol = lineCol;
    }

    public void match(@Nonnull String cdata, @Nonnull Context context, @Nonnull ValidatorProtos.ValidationResult.Builder validationResult) throws TagValidationException, CssValidationException, IOException {
        String combinedDisallowedCdataRegex;
        ValidatorProtos.CdataSpec cdataSpec = this.getTagSpec().getCdata();
        if (cdataSpec == null) {
            return;
        }
        if (cdataSpec.hasMaxBytes() && cdataSpec.getMaxBytes() != -2 && cdata.length() > cdataSpec.getMaxBytes()) {
            ArrayList<String> params = new ArrayList<String>();
            params.add(String.valueOf(cdata.length()));
            params.add(String.valueOf(cdataSpec.getMaxBytes()));
            context.addError(ValidatorProtos.ValidationError.Code.STYLESHEET_TOO_LONG, context.getLineCol(), params, cdataSpec.getMaxBytesSpecUrl(), validationResult);
            return;
        }
        int urlBytes = 0;
        ArrayList<String> params = new ArrayList<String>();
        params.add(TagSpecUtils.getTagSpecName(this.getTagSpec()));
        if (cdataSpec.hasMandatoryCdata()) {
            if (!cdataSpec.getMandatoryCdata().equals(cdata)) {
                context.addError(ValidatorProtos.ValidationError.Code.MANDATORY_CDATA_MISSING_OR_INCORRECT, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(this.getTagSpec()), validationResult);
            }
            return;
        }
        if (this.getTagSpec().getCdata().hasCdataRegex()) {
            if (!context.getRules().getFullMatchRegex(this.getTagSpec().getCdata().getCdataRegex()).matcher(cdata).matches()) {
                context.addError(ValidatorProtos.ValidationError.Code.MANDATORY_CDATA_MISSING_OR_INCORRECT, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(this.getTagSpec()), validationResult);
                return;
            }
        } else if (cdataSpec.hasCssSpec()) {
            urlBytes = this.matchCss(cdata, cdataSpec.getCssSpec(), context, validationResult);
        } else if (cdataSpec.getWhitespaceOnly() && !WHITE_SPACE_CHARACTER_PATTERN.matcher(cdata).matches()) {
            context.addError(ValidatorProtos.ValidationError.Code.NON_WHITESPACE_CDATA_ENCOUNTERED, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(this.getTagSpec()), validationResult);
        }
        ParsedDocCssSpec maybeDocCssSpec = context.matchingDocCssSpec();
        int adjustedCdataLength = ByteUtils.byteLength(cdata);
        if (maybeDocCssSpec != null && !maybeDocCssSpec.getSpec().getUrlBytesIncluded()) {
            adjustedCdataLength -= urlBytes;
        }
        if (context.getTagStack().countDocCssBytes()) {
            context.addStyleTagByteSize(adjustedCdataLength);
        }
        if ((combinedDisallowedCdataRegex = context.getRules().getCombinedDisallowedCdataRegex(this.parsedTagSpec.getId())) == null) {
            return;
        }
        if (!context.getRules().getPartialMatchCaseiRegex(combinedDisallowedCdataRegex).matcher(cdata).find()) {
            return;
        }
        for (ValidatorProtos.DisallowedCDataRegex disallowedList : cdataSpec.getDisallowedCdataRegexList()) {
            Pattern p = Pattern.compile(disallowedList.getRegex(), 2);
            if (!p.matcher(cdata).find()) continue;
            params.add(disallowedList.getErrorMessage());
            context.addError(ValidatorProtos.ValidationError.Code.CDATA_VIOLATES_DENYLIST, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(this.getTagSpec()), validationResult);
        }
    }

    public int matchCss(@Nonnull String cdata, @Nonnull ValidatorProtos.CssSpec cssSpec, @Nonnull Context context, @Nonnull ValidatorProtos.ValidationResult.Builder validationResult) throws CssValidationException, IOException {
        List<String> params;
        ArrayList<ErrorToken> cssErrors = new ArrayList<ErrorToken>();
        ArrayList cssWarnings = new ArrayList();
        CssParser cssParser = new CssParser(cdata, this.getLineCol().getLineNumber(), this.getLineCol().getColumnNumber(), cssErrors);
        List<Token> tokenList = cssParser.tokenize();
        CssParsingConfig cssParsingConfig = CssParsingConfig.computeCssParsingConfig();
        Stylesheet stylesheet = CssSpecUtils.parseAStylesheet(tokenList, cssParsingConfig.getAtRuleSpec(), cssParsingConfig.getDefaultSpec(), cssErrors);
        ParsedDocCssSpec maybeDocCssSpec = context.matchingDocCssSpec();
        ArrayList<ParsedCssUrl> parsedUrls = new ArrayList<ParsedCssUrl>();
        CssSpecUtils.extractUrls(stylesheet, parsedUrls, cssErrors);
        for (ValidatorProtos.AtRuleSpec atRuleSpec : cssSpec.getAtRuleSpecList()) {
            if (!atRuleSpec.hasMediaQuerySpec()) continue;
            if (!atRuleSpec.getName().equals("media")) {
                throw new CssValidationException("atRuleSpec name is not 'media'");
            }
            ValidatorProtos.MediaQuerySpec mediaQuerySpec = atRuleSpec.getMediaQuerySpec();
            ArrayList<ErrorToken> errorBuffer = mediaQuerySpec.getIssuesAsError() ? cssErrors : cssWarnings;
            this.matchMediaQuery(stylesheet, mediaQuerySpec, errorBuffer);
            break;
        }
        if (cssSpec.getValidateAmp4Ads()) {
            CssSpecUtils.validateAmp4AdsCss(stylesheet, cssErrors);
        }
        if (cssSpec.getValidateKeyframes()) {
            CssSpecUtils.validateKeyframesCss(stylesheet, cssErrors);
        }
        for (ErrorToken errorToken : cssErrors) {
            params = errorToken.getParams();
            params.set(0, TagSpecUtils.getTagSpecName(this.getTagSpec()));
            context.addError(errorToken.getCode(), context.getLineCol().getColumnNumber() + errorToken.getLine(), context.getLineCol().getColumnNumber() + errorToken.getCol(), params, "", validationResult);
        }
        for (ErrorToken errorToken : cssWarnings) {
            params = errorToken.getParams();
            params.set(0, TagSpecUtils.getTagSpecName(this.getTagSpec()));
            context.addError(errorToken.getCode(), context.getLineCol().getColumnNumber() + errorToken.getLine(), context.getLineCol().getColumnNumber() + errorToken.getCol(), params, "", validationResult);
        }
        if (!cssSpec.getAllowImportant()) {
            ArrayList<Declaration> important = new ArrayList<Declaration>();
            CssSpecUtils.extractImportantDeclarations(stylesheet, important);
            for (Declaration decl : important) {
                ArrayList<String> params2 = new ArrayList<String>();
                params2.add(TagSpecUtils.getTagSpecName(this.getTagSpec()));
                params2.add("CSS !important");
                context.addError(ValidatorProtos.ValidationError.Code.CDATA_VIOLATES_DENYLIST, context.getLineCol().getLineNumber() + decl.getLine(), context.getLineCol().getColumnNumber() + decl.getCol(), params2, TagSpecUtils.getTagSpecUrl(this.getTagSpec()), validationResult);
            }
        }
        int urlBytes = 0;
        for (ParsedCssUrl url : parsedUrls) {
            if (!UrlUtils.isDataUrl(url.getUtf8Url())) {
                urlBytes += ByteUtils.byteLength(url.getUtf8Url());
            }
            if (maybeDocCssSpec == null) continue;
            UrlErrorInStylesheetAdapter adapter = new UrlErrorInStylesheetAdapter(url.getLine(), url.getCol());
            ParsedUrlSpec parsedUrlSpec = maybeDocCssSpec.getImageUrlSpec();
            if (url.getAtRuleScope().equals("font-face")) {
                parsedUrlSpec = maybeDocCssSpec.getFontUrlSpec();
            }
            AttributeSpecUtils.validateUrlAndProtocol(parsedUrlSpec, adapter, context, url.getUtf8Url(), this.getTagSpec(), validationResult);
        }
        InvalidRuleVisitor invalidRuleVisitor = new InvalidRuleVisitor(this.getTagSpec(), cssSpec, context, validationResult);
        stylesheet.accept(invalidRuleVisitor);
        if (maybeDocCssSpec != null && !maybeDocCssSpec.getSpec().getAllowAllDeclarationInStyleTag()) {
            InvalidDeclVisitor invalidDeclVisitor = new InvalidDeclVisitor(maybeDocCssSpec, context, validationResult);
            stylesheet.accept(invalidDeclVisitor);
        }
        return urlBytes;
    }

    private void matchMediaQuery(@Nonnull Stylesheet stylesheet, @Nonnull ValidatorProtos.MediaQuerySpec spec, @Nonnull List<ErrorToken> errorBuffer) throws CssValidationException {
        ErrorToken errorToken;
        ArrayList<String> params;
        ArrayList<Token> seenMediaTypes = new ArrayList<Token>();
        ArrayList<Token> seenMediaFeatures = new ArrayList<Token>();
        MediaQueryVisitor.parseMediaQueries(stylesheet, seenMediaTypes, seenMediaFeatures, errorBuffer);
        for (Token token : seenMediaTypes) {
            String strippedMediaType = CssSpecUtils.stripVendorPrefix(token.toString().toLowerCase());
            if (spec.getTypeList().contains((Object)strippedMediaType)) continue;
            params = new ArrayList<String>();
            params.add("");
            params.add(token.toString());
            errorToken = new ErrorToken(ValidatorProtos.ValidationError.Code.CSS_SYNTAX_DISALLOWED_MEDIA_TYPE, params);
            CssTokenUtil.copyPosTo(token, errorToken);
            errorBuffer.add(errorToken);
        }
        for (Token token : seenMediaFeatures) {
            String strippedMediaFeature = CssSpecUtils.stripMinMax(CssSpecUtils.stripVendorPrefix(token.toString().toLowerCase()));
            if (spec.getFeatureList().contains((Object)strippedMediaFeature)) continue;
            params = new ArrayList();
            params.add("");
            params.add(token.toString());
            errorToken = new ErrorToken(ValidatorProtos.ValidationError.Code.CSS_SYNTAX_DISALLOWED_MEDIA_FEATURE, params);
            CssTokenUtil.copyPosTo(token, errorToken);
            errorBuffer.add(errorToken);
        }
    }

    public Locator getLineCol() {
        return this.lineCol;
    }

    public ValidatorProtos.TagSpec getTagSpec() {
        return this.parsedTagSpec.getSpec();
    }
}

