/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator;

import dev.amp.validator.ValidatorProtos;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;

public class ParsedUrlSpec {
    @Nonnull
    private ValidatorProtos.UrlSpec spec;
    @Nonnull
    private Set<String> allowedProtocols;

    public ParsedUrlSpec(@Nonnull ValidatorProtos.UrlSpec urlSpec) {
        this.spec = urlSpec;
        this.allowedProtocols = new HashSet<String>();
        if (this.spec != null) {
            for (String protocol : this.spec.getProtocolList()) {
                this.allowedProtocols.add(protocol);
            }
        }
    }

    public ValidatorProtos.UrlSpec getSpec() {
        return this.spec;
    }

    public boolean isAllowedProtocol(String protocol) {
        return this.allowedProtocols.contains(protocol);
    }

    public void cleanup() {
        this.allowedProtocols = null;
    }
}

