/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator;

import com.google.protobuf.ProtocolStringList;
import dev.amp.validator.CdataMatcher;
import dev.amp.validator.ChildTagMatcher;
import dev.amp.validator.ParsedAttrSpec;
import dev.amp.validator.ParsedAttrSpecs;
import dev.amp.validator.ParsedReferencePoints;
import dev.amp.validator.ParsedValidatorRules;
import dev.amp.validator.RecordValidated;
import dev.amp.validator.ReferencePointMatcher;
import dev.amp.validator.ValidatorProtos;
import dev.amp.validator.exception.TagValidationException;
import dev.amp.validator.utils.AttributeSpecUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.xml.sax.Locator;

public class ParsedTagSpec {
    private ValidatorProtos.TagSpec spec;
    private int id;
    private ParsedReferencePoints referencePoints;
    private boolean isReferencePoint;
    private boolean isTypeJson;
    private RecordValidated shouldRecordTagspecValidated;
    private boolean attrsCanSatisfyExtension;
    private Map<String, ValidatorProtos.AttrSpec> attrsByName;
    private Set<ValidatorProtos.AttrSpec> mandatoryAttrs;
    private Set<String> mandatoryOneofs;
    private Set<String> mandatoryAnyofs;
    private List<ValidatorProtos.AttrSpec> implicitAttrspecs;
    private boolean containsUrl;

    public ParsedTagSpec(@Nonnull ParsedAttrSpecs parsedAttrSpecs, @Nonnull RecordValidated shouldRecordTagsValidated, @Nonnull ValidatorProtos.TagSpec tagSpec, int id) {
        this.spec = tagSpec;
        this.id = id;
        this.referencePoints = new ParsedReferencePoints(tagSpec);
        this.isReferencePoint = tagSpec.getTagName().equals("$REFERENCE_POINT");
        this.isTypeJson = false;
        this.shouldRecordTagspecValidated = shouldRecordTagsValidated;
        this.attrsCanSatisfyExtension = false;
        this.attrsByName = new HashMap<String, ValidatorProtos.AttrSpec>();
        this.mandatoryAttrs = new HashSet<ValidatorProtos.AttrSpec>();
        this.mandatoryAnyofs = new HashSet<String>();
        this.mandatoryOneofs = new HashSet<String>();
        this.implicitAttrspecs = new ArrayList<ValidatorProtos.AttrSpec>();
        this.containsUrl = false;
        if (!tagSpec.hasExplicitAttrsOnly() && tagSpec.getAmpLayout() != null && !this.isReferencePoint) {
            this.mergeAttrs(parsedAttrSpecs.getAmpLayoutAttrs(), parsedAttrSpecs);
        }
        this.mergeAttrs(tagSpec.getAttrsList(), parsedAttrSpecs);
        for (String attrLists : tagSpec.getAttrListsList()) {
            this.mergeAttrs(parsedAttrSpecs.getAttrListByName(attrLists), parsedAttrSpecs);
        }
        if (!tagSpec.hasExplicitAttrsOnly() && !this.isReferencePoint) {
            this.mergeAttrs(parsedAttrSpecs.getGlobalAttrs(), parsedAttrSpecs);
        }
    }

    public ValidatorProtos.TagSpec getSpec() {
        return this.spec;
    }

    public CdataMatcher cdataMatcher(@Nonnull Locator lineCol) {
        if (this.spec.getCdata() != null) {
            return new CdataMatcher(this, lineCol);
        }
        return null;
    }

    public ChildTagMatcher childTagMatcher() throws TagValidationException {
        if (this.spec.hasChildTags()) {
            return new ChildTagMatcher(this.spec);
        }
        return null;
    }

    public ReferencePointMatcher referencePointMatcher(@Nonnull ParsedValidatorRules rules, @Nonnull Locator lineCol) throws TagValidationException {
        if (this.hasReferencePoints()) {
            return new ReferencePointMatcher(rules, this.referencePoints, lineCol);
        }
        return null;
    }

    public boolean isTypeJson() {
        return this.isTypeJson;
    }

    public int getId() {
        return this.id;
    }

    public boolean isUsedForTypeIdentifiers(@Nonnull List<String> typeIdentifiers) {
        return AttributeSpecUtils.isUsedForTypeIdentifiers(typeIdentifiers, (List<String>)this.spec.getEnabledByList(), (List<String>)this.spec.getDisabledByList());
    }

    public List<String> getAlsoRequiresTagWarning() {
        return this.spec.getAlsoRequiresTagWarningList();
    }

    public List<String> requires() {
        return this.spec.getRequiresList();
    }

    public List<String> excludes() {
        return this.spec.getExcludesList();
    }

    public boolean containsUrl() {
        return this.containsUrl;
    }

    public RecordValidated shouldRecordTagspecValidated() {
        return this.shouldRecordTagspecValidated;
    }

    public boolean isReferencePoint() {
        return this.isReferencePoint;
    }

    public boolean hasReferencePoints() {
        return !this.referencePoints.empty();
    }

    public ParsedReferencePoints getReferencePoints() {
        return this.referencePoints;
    }

    public boolean attrsCanSatisfyExtension() {
        return this.attrsCanSatisfyExtension;
    }

    public boolean hasAttrWithName(@Nonnull String name) {
        return this.attrsByName.containsKey(name);
    }

    public List<ValidatorProtos.AttrSpec> getImplicitAttrspecs() {
        return this.implicitAttrspecs;
    }

    public Map<String, ValidatorProtos.AttrSpec> getAttrsByName() {
        return this.attrsByName;
    }

    public Set<String> getMandatoryOneofs() {
        return this.mandatoryOneofs;
    }

    public Set<String> getMandatoryAnyofs() {
        return this.mandatoryAnyofs;
    }

    public Set<ValidatorProtos.AttrSpec> getMandatoryAttrIds() {
        return this.mandatoryAttrs;
    }

    private void mergeAttrs(List<ValidatorProtos.AttrSpec> attrs, ParsedAttrSpecs parsedAttrSpecs) {
        for (ValidatorProtos.AttrSpec attrSpec : attrs) {
            String name = attrSpec.getName();
            if (this.attrsByName.containsKey(name)) continue;
            this.attrsByName.put(name, attrSpec);
            if (attrSpec.getName() != null && attrSpec.getAllFields().size() == 1) continue;
            if (attrSpec.getValueCaseiCount() > 0) {
                for (String valueCasei : attrSpec.getValueCaseiList()) {
                    this.populateAttrSpec(name, valueCasei, parsedAttrSpecs, attrSpec);
                }
                continue;
            }
            this.populateAttrSpec(name, "", parsedAttrSpecs, attrSpec);
        }
    }

    public int id() {
        return this.id;
    }

    public void cleanup() {
        this.spec = null;
        this.referencePoints = null;
        this.attrsByName = null;
        this.mandatoryAttrs = null;
        this.mandatoryOneofs = null;
        this.mandatoryAnyofs = null;
        this.implicitAttrspecs = null;
    }

    private void populateAttrSpec(@Nonnull String name, @Nonnull String value, @Nonnull ParsedAttrSpecs parsedAttrSpecs, @Nonnull ValidatorProtos.AttrSpec attrSpec) {
        ParsedAttrSpec attr = parsedAttrSpecs.getParsedAttrSpec(this.spec.getTagName(), name, value, attrSpec);
        if (attr != null) {
            ValidatorProtos.AttrSpec spec = attr.getSpec();
            if (spec.hasMandatory()) {
                this.mandatoryAttrs.add(spec);
            }
            if (spec.hasMandatoryOneof()) {
                this.mandatoryOneofs.add(spec.getMandatoryOneof());
            }
            if (spec.hasMandatoryAnyof()) {
                this.mandatoryAnyofs.add(spec.getMandatoryAnyof());
            }
            ProtocolStringList protocolStringList = spec.getAlternativeNamesList();
            for (String altName : protocolStringList) {
                this.attrsByName.put(altName, attrSpec);
            }
            if (spec.hasImplicit()) {
                this.implicitAttrspecs.add(attrSpec);
            }
            if (spec.getName().equals("type") && spec.getValueCaseiList().size() > 0) {
                for (String v : spec.getValueCaseiList()) {
                    if (!"application/json".equals(v)) continue;
                    this.isTypeJson = true;
                    break;
                }
            }
            if (spec.hasValueUrl()) {
                this.containsUrl = true;
            }
            if (spec.getRequiresExtensionList().size() > 0) {
                this.attrsCanSatisfyExtension = true;
            }
        }
    }
}

