/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator.css;

import com.steadystate.css.parser.CharStream;
import com.steadystate.css.parser.CssCharStream;
import com.steadystate.css.parser.ListableTokenManager;
import com.steadystate.css.parser.ParseException;
import com.steadystate.css.parser.SACParserCSS3;
import com.steadystate.css.parser.Token;
import com.steadystate.css.parser.TokenMgrError;
import dev.amp.validator.ValidatorProtos;
import dev.amp.validator.css.CssErrorHandler;
import dev.amp.validator.css.CssTokenUtil;
import dev.amp.validator.css.CssValidationException;
import dev.amp.validator.css.EOFToken;
import dev.amp.validator.css.ErrorToken;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.InputSource;

public final class CssParser
extends SACParserCSS3 {
    @Nonnull
    private List<ErrorToken> errors;
    private int line;
    private int col;
    private InputSource source;

    public CssParser(@Nonnull String cssText, int line, int col, @Nonnull List<ErrorToken> errors) {
        this.errors = errors;
        this.setErrorHandler(new CssErrorHandler());
        this.line = line;
        this.col = col;
        this.source = new InputSource((Reader)new StringReader(cssText));
        ListableTokenManager manager = new ListableTokenManager((CharStream)new CssCharStream(this.source.getCharacterStream(), 1, 1));
        this.ReInit(manager);
    }

    protected CSSParseException toCSSParseException(String key, @Nonnull ParseException ex) {
        try {
            ArrayList<String> params;
            if (ex.currentToken != null && ex.currentToken.next != null && ex.currentToken.next.image != null && ex.currentToken.next.image.equals("\\")) {
                params = new ArrayList<String>();
                params.add("style");
                this.errors.add((ErrorToken)CssTokenUtil.copyPosTo(ex.currentToken.next, new ErrorToken(ValidatorProtos.ValidationError.Code.CSS_SYNTAX_STRAY_TRAILING_BACKSLASH, params)));
            }
            if (ex.currentToken != null && ex.currentToken.next != null && ex.currentToken.next.image != null && (ex.currentToken.next.image.equals("\"") || ex.currentToken.next.image.equals("'"))) {
                params = new ArrayList();
                params.add("style");
                this.errors.add((ErrorToken)CssTokenUtil.copyPosTo(ex.currentToken.next, new ErrorToken(ValidatorProtos.ValidationError.Code.CSS_SYNTAX_UNTERMINATED_STRING, params)));
            }
        }
        catch (CssValidationException cssValidationException) {
            // empty catch block
        }
        return super.toCSSParseException(key, ex);
    }

    protected CSSParseException toCSSParseException(TokenMgrError ex) {
        if (((ListableTokenManager)this.token_source).getCurLexState() == 1) {
            ArrayList<String> params = new ArrayList<String>();
            params.add("style");
            try {
                this.errors.add((ErrorToken)CssTokenUtil.copyPosTo(this.token, new ErrorToken(ValidatorProtos.ValidationError.Code.CSS_SYNTAX_UNTERMINATED_COMMENT, params)));
                ((ListableTokenManager)this.token_source).getParsedTokens().add(new EOFToken());
            }
            catch (CssValidationException cssValidationException) {
                // empty catch block
            }
        }
        return super.toCSSParseException(ex);
    }

    public List<Token> tokenize() throws IOException {
        this.parseStyleSheet(this.source);
        return ((ListableTokenManager)this.token_source).getParsedTokens();
    }

    public List<ErrorToken> getErrors() {
        return this.errors;
    }
}

