/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator.utils;

import dev.amp.validator.Context;
import dev.amp.validator.ParsedHtmlTag;
import dev.amp.validator.ValidatorProtos;
import dev.amp.validator.utils.TagSpecUtils;
import java.util.ArrayList;
import javax.annotation.Nonnull;

public final class ExtensionsUtils {
    public static final String[] EXTENSION_SCRIPT_NAMES = new String[]{"custom-element", "custom-template", "host-service"};

    private ExtensionsUtils() {
    }

    public static void validateAmpScriptSrcAttr(@Nonnull ParsedHtmlTag tag, @Nonnull String attrValue, @Nonnull ValidatorProtos.TagSpec tagSpec, @Nonnull Context context, @Nonnull ValidatorProtos.ValidationResult.Builder result) {
        if (!tag.isAmpDomain()) {
            context.addError(ValidatorProtos.ValidationError.Code.DISALLOWED_AMP_DOMAIN, context.getLineCol(), new ArrayList<String>(), "", result);
        }
        if (tag.isExtensionScript() && tagSpec.hasExtensionSpec()) {
            ValidatorProtos.ExtensionSpec extensionSpec = tagSpec.getExtensionSpec();
            String extensionName = tag.getExtensionName();
            String extensionVersion = tag.getExtensionVersion();
            if (!tag.hasValidAmpScriptPath()) {
                if (tag.getAmpScriptPath().length() > 0) {
                    ArrayList<String> params = new ArrayList<String>();
                    params.add(extensionSpec.getName());
                    params.add(tag.getAmpScriptPath());
                    context.addError(ValidatorProtos.ValidationError.Code.INVALID_EXTENSION_PATH, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(tagSpec), result);
                } else {
                    ArrayList<String> params = new ArrayList<String>();
                    params.add("src");
                    params.add(TagSpecUtils.getTagDescriptiveName(tagSpec));
                    params.add(attrValue);
                    context.addError(ValidatorProtos.ValidationError.Code.INVALID_ATTR_VALUE, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(tagSpec), result);
                }
                return;
            }
            if (extensionName.equals(extensionSpec.getName())) {
                ArrayList<String> params;
                if (extensionSpec.getDeprecatedVersionList().contains((Object)extensionVersion)) {
                    params = new ArrayList<String>();
                    params.add(extensionSpec.getName());
                    params.add(extensionVersion);
                    context.addWarning(ValidatorProtos.ValidationError.Code.WARNING_EXTENSION_DEPRECATED_VERSION, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(tagSpec), result);
                }
                if (!extensionSpec.getVersionList().contains((Object)extensionVersion)) {
                    params = new ArrayList();
                    params.add(extensionSpec.getName());
                    params.add(extensionVersion);
                    context.addError(ValidatorProtos.ValidationError.Code.INVALID_EXTENSION_VERSION, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(tagSpec), result);
                }
            } else {
                ArrayList<String> params = new ArrayList<String>();
                params.add("src");
                params.add(TagSpecUtils.getTagDescriptiveName(tagSpec));
                params.add(attrValue);
                context.addError(ValidatorProtos.ValidationError.Code.INVALID_ATTR_VALUE, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(tagSpec), result);
            }
        }
        if (context.getScriptReleaseVersion() != ScriptReleaseVersion.UNKNOWN) {
            ScriptReleaseVersion scriptReleaseVersion = tag.getScriptReleaseVersion();
            if (context.getScriptReleaseVersion() != scriptReleaseVersion) {
                String specName = tagSpec.hasExtensionSpec() ? tagSpec.getExtensionSpec().getName() : tagSpec.getSpecName();
                switch (context.getScriptReleaseVersion()) {
                    case LTS: 
                    case MODULE_NOMODULE: 
                    case MODULE_NOMODULE_LTS: 
                    case STANDARD: {
                        ArrayList<String> params = new ArrayList<String>();
                        params.add(specName);
                        params.add(scriptReleaseVersion.toString());
                        params.add(context.getScriptReleaseVersion().toString());
                        context.addError(ValidatorProtos.ValidationError.Code.INCORRECT_SCRIPT_RELEASE_VERSION, context.getLineCol(), params, "https://amp.dev/documentation/guides-and-tutorials/learn/spec/amphtml#required-markup", result);
                        break;
                    }
                }
            }
        }
    }

    public static enum ScriptReleaseVersion {
        UNKNOWN,
        STANDARD,
        LTS,
        MODULE_NOMODULE,
        MODULE_NOMODULE_LTS;

    }
}

