/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator;

import dev.amp.validator.AMPValidatorLoader;
import dev.amp.validator.ValidatorProtos;
import dev.amp.validator.exception.TagValidationException;
import dev.amp.validator.utils.DispatchKeyUtils;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class AMPValidatorManager {
    @Nonnull
    private ValidatorProtos.ValidatorRules.Builder builder = null;
    @Nonnull
    private final Map<ValidatorProtos.HtmlFormat.Code, Map<String, List<ValidatorProtos.TagSpec>>> tagSpecMapByHtmlFormat = new HashMap<ValidatorProtos.HtmlFormat.Code, Map<String, List<ValidatorProtos.TagSpec>>>();
    @Nonnull
    private final Map<String, ValidatorProtos.AttrList> attrListMap = new HashMap<String, ValidatorProtos.AttrList>();
    @Nonnull
    private final Map<Integer, String> dispatchKeyByTagSpecId = new HashMap<Integer, String>();
    private Map<String, String> combinedDisallowedCdataRegexMap;

    public void loadRule() throws IOException, URISyntaxException {
        this.loadRule(null);
    }

    public void loadRule(String filePath) throws IOException, URISyntaxException {
        AMPValidatorLoader ampValidatorLoader = new AMPValidatorLoader();
        this.builder = ampValidatorLoader.load(filePath);
        this.combinedDisallowedCdataRegexMap = new HashMap<String, String>();
        List<ValidatorProtos.TagSpec> tagSpecs = this.builder.getTagsList();
        int tagSpecId = 0;
        for (ValidatorProtos.TagSpec tagSpec : tagSpecs) {
            List<ValidatorProtos.DisallowedCDataRegex> disallowedCDataRegexList;
            ArrayList<ValidatorProtos.TagSpec> tagSpecList;
            List<ValidatorProtos.HtmlFormat.Code> htmlFormats = tagSpec.getHtmlFormatList();
            for (ValidatorProtos.HtmlFormat.Code htmlFormat : htmlFormats) {
                Map<String, List<ValidatorProtos.TagSpec>> tagSpecMap = this.tagSpecMapByHtmlFormat.get((Object)htmlFormat);
                if (tagSpecMap == null) {
                    tagSpecMap = new HashMap<String, List<ValidatorProtos.TagSpec>>();
                    tagSpecMap.put(tagSpec.getTagName(), new ArrayList());
                    this.tagSpecMapByHtmlFormat.put(htmlFormat, tagSpecMap);
                }
                if ((tagSpecList = tagSpecMap.get(tagSpec.getTagName())) == null) {
                    tagSpecList = new ArrayList<ValidatorProtos.TagSpec>();
                }
                tagSpecList.add(tagSpec);
                tagSpecMap.put(tagSpec.getTagName(), tagSpecList);
            }
            String dispatchKey = DispatchKeyUtils.getDispatchKeyForTagSpecOrNone(tagSpec);
            if (dispatchKey != null) {
                this.dispatchKeyByTagSpecId.put(tagSpecId, dispatchKey);
            }
            if ((disallowedCDataRegexList = tagSpec.getCdata().getDisallowedCdataRegexList()) != null) {
                ArrayList<String> combined = new ArrayList<String>();
                tagSpecList = disallowedCDataRegexList.iterator();
                while (tagSpecList.hasNext()) {
                    ValidatorProtos.DisallowedCDataRegex disallowedCDataRegex = (ValidatorProtos.DisallowedCDataRegex)tagSpecList.next();
                    combined.add(disallowedCDataRegex.getRegex());
                }
                if (!combined.isEmpty()) {
                    String combinedDisallowedCdataRegex = String.join((CharSequence)"|", combined);
                    this.combinedDisallowedCdataRegexMap.put(String.valueOf(tagSpecId), combinedDisallowedCdataRegex);
                }
            }
            ++tagSpecId;
        }
        List<ValidatorProtos.AttrList> attrListsList = this.builder.getAttrListsList();
        for (ValidatorProtos.AttrList attrList : attrListsList) {
            this.attrListMap.put(attrList.getName(), attrList);
        }
    }

    public boolean hasTagSpec(@Nonnull ValidatorProtos.HtmlFormat.Code htmlFormat, @Nonnull String name) {
        Map<String, List<ValidatorProtos.TagSpec>> tagSpecMap = this.tagSpecMapByHtmlFormat.get((Object)htmlFormat);
        return tagSpecMap != null ? tagSpecMap.containsKey(name) : false;
    }

    public List<ValidatorProtos.TagSpec> getTagSpec(@Nonnull ValidatorProtos.HtmlFormat.Code htmlFormat, @Nonnull String name) {
        Map<String, List<ValidatorProtos.TagSpec>> tagSpecMap = this.tagSpecMapByHtmlFormat.get((Object)htmlFormat);
        return tagSpecMap != null ? tagSpecMap.get(name) : null;
    }

    public ValidatorProtos.AttrList getAttrList(@Nonnull String name) {
        return this.attrListMap.get(name);
    }

    public List<ValidatorProtos.TagSpec> getListTagSpecByName(@Nonnull ValidatorProtos.HtmlFormat.Code htmlFormat, @Nonnull String tagName) {
        Map<String, List<ValidatorProtos.TagSpec>> tagMap = this.tagSpecMapByHtmlFormat.get((Object)htmlFormat);
        return tagMap != null ? tagMap.get(tagName) : null;
    }

    public ValidatorProtos.ValidatorRules.Builder getRules() {
        return this.builder;
    }

    public List<ValidatorProtos.AttrSpec> getGlobalAttrs() {
        for (ValidatorProtos.AttrList attrList : this.builder.getAttrListsList()) {
            if (!attrList.getName().equals("$GLOBAL_ATTRS")) continue;
            return attrList.getAttrsList();
        }
        return Collections.emptyList();
    }

    public List<ValidatorProtos.AttrSpec> getAmpLayoutAttrs() {
        for (ValidatorProtos.AttrList attrList : this.builder.getAttrListsList()) {
            if (!attrList.getName().equals("$AMP_LAYOUT_ATTRS")) continue;
            return attrList.getAttrsList();
        }
        return Collections.emptyList();
    }

    public List<ValidatorProtos.DescendantTagList> getDescendantTagLists() {
        return this.builder.getDescendantTagListList();
    }

    public String getDispatchKeyByTagSpecId(int tagSpecId) {
        return this.dispatchKeyByTagSpecId.get(tagSpecId);
    }

    public int getTagSpecIdByReferencePointTagSpecName(@Nonnull String specName) throws TagValidationException {
        int index = 0;
        for (ValidatorProtos.TagSpec tagSpec : this.builder.getTagsList()) {
            if (tagSpec.getTagName().equals("$REFERENCE_POINT") && tagSpec.getSpecName().equals(specName)) {
                return index;
            }
            ++index;
        }
        throw new TagValidationException("The reference point with spec name " + specName + " does not exist");
    }

    public String getStylesSpecUrl() {
        return this.builder.getStylesSpecUrl();
    }

    public String getScriptSpecUrl() {
        return this.builder.getScriptSpecUrl();
    }

    public Map<String, ValidatorProtos.AttrList> getAttrListMap() {
        return this.attrListMap;
    }

    public String getCombinedDisallowedCdataRegex(int tagSpecId) {
        return this.combinedDisallowedCdataRegexMap.get(Integer.toString(tagSpecId));
    }
}

