/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class CssLength {
    private boolean isValid = false;
    private boolean isSet = false;
    private boolean isAuto = false;
    private boolean isFluid = false;
    private Float numeral = Float.valueOf(Float.NaN);
    private String unit = "px";
    private static final Pattern CSS_LENGTH_PATTERN = Pattern.compile("^(\\d+(?:\\.\\d+)?)(px|em|rem|vh|vw|vmin|vmax)?$");

    public CssLength(@Nonnull String input, boolean allowAuto, boolean allowFluid) {
        Matcher matcher;
        if (input == null) {
            this.isValid = true;
            return;
        }
        this.isSet = true;
        if (input.equals("auto")) {
            this.isAuto = true;
            this.isValid = allowAuto;
            return;
        }
        if (input.equals("fluid")) {
            this.isFluid = true;
            this.isValid = allowFluid;
        }
        if ((matcher = CSS_LENGTH_PATTERN.matcher(input)).matches()) {
            this.isValid = true;
            this.numeral = Float.valueOf(Float.parseFloat(matcher.group(1)));
            this.unit = matcher.group(2) != null ? matcher.group(2) : "px";
        }
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean isSet() {
        return this.isSet;
    }

    public boolean isAuto() {
        return this.isAuto;
    }

    public boolean isFluid() {
        return this.isFluid;
    }

    public Float getNumeral() {
        return this.numeral;
    }

    public String getUnit() {
        return this.unit;
    }
}

