/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator;

import dev.amp.validator.ExtensionMissingError;
import dev.amp.validator.ParsedTagSpec;
import dev.amp.validator.ValidateTagResult;
import dev.amp.validator.ValidatorProtos;
import dev.amp.validator.utils.TagSpecUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.xml.sax.Locator;

public class ExtensionsContext {
    private Map<String, Boolean> extensionsLoaded = new HashMap<String, Boolean>();
    private List<String> extensionsUnusedRequired;
    private Map<String, Boolean> extensionsUsed;
    private List<ExtensionMissingError> extensionMissingErrors;

    public ExtensionsContext() {
        this.extensionsLoaded.put("amp-ad", true);
        this.extensionsUnusedRequired = new ArrayList<String>();
        this.extensionMissingErrors = new ArrayList<ExtensionMissingError>();
        this.extensionsUsed = new HashMap<String, Boolean>();
    }

    public List<ValidatorProtos.ValidationError> missingExtensionErrors() {
        ArrayList<ValidatorProtos.ValidationError> out = new ArrayList<ValidatorProtos.ValidationError>();
        for (ExtensionMissingError err : this.extensionMissingErrors) {
            if (this.isExtensionLoaded(err.getMissingExtension())) continue;
            out.add(err.getMaybeError());
        }
        return out;
    }

    public boolean isExtensionLoaded(@Nonnull String extension) {
        return this.extensionsLoaded.containsKey(extension);
    }

    public List<String> unusedExtensionsRequired() {
        ArrayList<String> out = new ArrayList<String>();
        for (String extension : this.extensionsUnusedRequired) {
            if (this.extensionsUsed.containsKey(extension)) continue;
            out.add(extension);
        }
        Collections.sort(out);
        return out;
    }

    public void updateFromTagResult(@Nonnull ValidateTagResult result) {
        if (result.getBestMatchTagSpec() == null) {
            return;
        }
        ParsedTagSpec parsedTagSpec = result.getBestMatchTagSpec();
        ValidatorProtos.TagSpec tagSpec = parsedTagSpec.getSpec();
        if (tagSpec.hasExtensionSpec()) {
            ValidatorProtos.ExtensionSpec extensionSpec = tagSpec.getExtensionSpec();
            String extensionName = extensionSpec.getName();
            this.extensionsLoaded.put(extensionName, true);
            switch (extensionSpec.getRequiresUsage()) {
                case EXEMPTED: 
                case NONE: {
                    break;
                }
                default: {
                    this.extensionsUnusedRequired.add(extensionName);
                }
            }
        }
        this.recordUsedExtensions((List<String>)tagSpec.getRequiresExtensionList());
    }

    public void recordUsedExtensions(@Nonnull List<String> extensions) {
        for (String extension : extensions) {
            this.extensionsUsed.put(extension, true);
        }
    }

    public void recordFutureErrorsIfMissing(@Nonnull ParsedTagSpec parsedTagSpec, @Nonnull Locator lineCol) {
        ValidatorProtos.TagSpec tagSpec = parsedTagSpec.getSpec();
        for (String requiredExtension : tagSpec.getRequiresExtensionList()) {
            if (this.isExtensionLoaded(requiredExtension)) continue;
            ValidatorProtos.ValidationError.Builder error = ValidatorProtos.ValidationError.newBuilder();
            error.setSeverity(ValidatorProtos.ValidationError.Severity.ERROR);
            error.setCode(ValidatorProtos.ValidationError.Code.MISSING_REQUIRED_EXTENSION);
            ArrayList<String> params = new ArrayList<String>();
            params.add(TagSpecUtils.getTagSpecName(tagSpec));
            params.add(requiredExtension);
            error.addAllParams(params);
            error.setLine(lineCol.getLineNumber());
            error.setCol(lineCol.getColumnNumber());
            error.setSpecUrl(TagSpecUtils.getTagSpecUrl(tagSpec));
            this.extensionMissingErrors.add(new ExtensionMissingError(requiredExtension, error.build()));
        }
    }
}

