/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator.selector;

import dev.amp.validator.css.TokenType;
import dev.amp.validator.selector.Selector;
import dev.amp.validator.visitor.SelectorVisitor;
import java.util.ArrayDeque;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public class SelectorsGroup
extends Selector {
    private final ArrayDeque<Selector> elements;

    public SelectorsGroup(@Nonnull ArrayDeque<Selector> elements) {
        this.elements = elements;
    }

    @Override
    public void forEachChild(Consumer<Selector> lambda) {
        for (Selector selector : this.elements) {
            lambda.accept(selector);
        }
    }

    @Override
    public void accept(@Nonnull SelectorVisitor visitor) {
        visitor.visitSelectorsGroup(this);
    }

    @Override
    public TokenType getTokenType() {
        return TokenType.SELECTORS_GROUP;
    }

    public ArrayDeque<Selector> getElements() {
        return this.elements;
    }
}

