/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator.utils;

import com.steadystate.css.parser.Token;
import dev.amp.validator.Context;
import dev.amp.validator.CssLength;
import dev.amp.validator.ExtensionsContext;
import dev.amp.validator.ParsedAttrSpec;
import dev.amp.validator.ParsedHtmlTag;
import dev.amp.validator.ParsedTagSpec;
import dev.amp.validator.ParsedUrlSpec;
import dev.amp.validator.ParsedValueProperties;
import dev.amp.validator.SrcsetParsingResult;
import dev.amp.validator.SrcsetSourceDef;
import dev.amp.validator.UrlErrorAdapter;
import dev.amp.validator.UrlErrorInAttrAdapter;
import dev.amp.validator.ValidateTagResult;
import dev.amp.validator.ValidatorProtos;
import dev.amp.validator.css.CssParser;
import dev.amp.validator.css.CssValidationException;
import dev.amp.validator.css.Declaration;
import dev.amp.validator.css.ErrorToken;
import dev.amp.validator.exception.TagValidationException;
import dev.amp.validator.utils.CssSpecUtils;
import dev.amp.validator.utils.ExtensionsUtils;
import dev.amp.validator.utils.ParseSrcSetUtils;
import dev.amp.validator.utils.TagSpecUtils;
import dev.amp.validator.utils.ValidationErrorUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.text.StringEscapeUtils;

public final class AttributeSpecUtils {
    private static final Pattern URL_PROTOCOL_PATTERN = Pattern.compile("^([^:\\/?#.]+):.*$");
    private static final Pattern ONLY_WHITESPACE_PATTERN = Pattern.compile("^[\\s\\xa0]*$");
    private static final Pattern PARTIALS_PATTERN = Pattern.compile("\\{\\{\\s*>");
    private static final Pattern UNESCAPED_OPEN_TAG = Pattern.compile("\\{\\{\\s*[&{]");
    private static final Pattern DATA_PATTERN = Pattern.compile("^data-[A-Za-z0-9-_:.]*$");
    private static final Pattern MUSTACHE_TAG_PATTERN = Pattern.compile("\\{\\{.*\\}\\}");
    private static final Pattern SRC_URL_REGEX = Pattern.compile("^https:\\/\\/cdn\\.ampproject\\.org\\/v0\\/(amp-[a-z0-9-]*)-([a-z0-9.]*)\\.(?:m)?js(?:\\?f=sxg)?$");

    private AttributeSpecUtils() {
    }

    public static boolean isUsedForTypeIdentifiers(@Nonnull List<String> typeIdentifiers, @Nonnull List<String> enabledBys, @Nonnull List<String> disabledBys) {
        if (enabledBys.size() > 0) {
            for (String enabledBy : enabledBys) {
                if (!typeIdentifiers.contains(enabledBy)) continue;
                return true;
            }
            return false;
        }
        if (disabledBys.size() > 0) {
            for (String disabledBy : disabledBys) {
                if (!typeIdentifiers.contains(disabledBy)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static void validateAttributes(@Nonnull ParsedTagSpec parsedTagSpec, @Nonnull ParsedTagSpec bestMatchReferencePoint, @Nonnull Context context, @Nonnull ParsedHtmlTag encounteredTag, @Nonnull ValidateTagResult result) throws TagValidationException, IOException, CssValidationException {
        Object params;
        ArrayList<String> params2;
        ValidatorProtos.TagSpec spec = parsedTagSpec.getSpec();
        if (spec.hasAmpLayout()) {
            AttributeSpecUtils.validateLayout(parsedTagSpec, context, encounteredTag, result.getValidationResult());
        }
        boolean seenExtensionSrcAttr = false;
        boolean hasTemplateAncestor = context.getTagStack().hasAncestor("TEMPLATE");
        boolean isHtmlTag = encounteredTag.upperName().equals("HTML");
        ArrayList<String> mandatoryAttrsSeen = new ArrayList<String>();
        ArrayList<String> mandatoryOneofsSeen = new ArrayList<String>();
        ArrayList<String> mandatoryAnyofsSeen = new ArrayList<String>();
        ArrayList<ValidatorProtos.AttrSpec> triggersToCheck = new ArrayList<ValidatorProtos.AttrSpec>();
        HashSet<String> attrspecsValidated = new HashSet<String>();
        for (ValidatorProtos.AttrSpec implicit : parsedTagSpec.getImplicitAttrspecs()) {
            attrspecsValidated.add(implicit.getName());
        }
        Map<String, ValidatorProtos.AttrSpec> attrsByName = parsedTagSpec.getAttrsByName();
        for (int i = 0; i < encounteredTag.attrs().getLength(); ++i) {
            ValidatorProtos.AttrTriggerSpec trigger;
            Pattern regex;
            ValidatorProtos.AttrSpec attrSpec;
            String value;
            String string = encounteredTag.attrs().getLocalName(i);
            if (string.equals(value = encounteredTag.attrs().getValue(i))) {
                value = "";
            }
            if (context.isTransformed() && !encounteredTag.lowerName().equals("i-amphtml-sizer") && (string.equals("class") || string.equals("i-amphtml-layout"))) continue;
            if (string.equals("src") && (encounteredTag.isExtensionScript() || encounteredTag.isAmpRuntimeScript())) {
                ExtensionsUtils.validateAmpScriptSrcAttr(encounteredTag, value, spec, context, result.getValidationResult());
                if (encounteredTag.isExtensionScript()) {
                    seenExtensionSrcAttr = true;
                    continue;
                }
            }
            if (!attrsByName.containsKey(string)) {
                if (isHtmlTag && context.getRules().isTypeIdentifier(string) || parsedTagSpec.isReferencePoint() || bestMatchReferencePoint != null && bestMatchReferencePoint.hasAttrWithName(string) || spec.hasExtensionSpec() && AttributeSpecUtils.validateAttrInExtension(spec, string, value)) continue;
                AttributeSpecUtils.validateAttrNotFoundInSpec(parsedTagSpec, context, string, result.getValidationResult());
                if (result.getValidationResult().getStatus() == ValidatorProtos.ValidationResult.Status.FAIL || !hasTemplateAncestor) continue;
                AttributeSpecUtils.validateAttrValueBelowTemplateTag(parsedTagSpec, context, string, value, result.getValidationResult());
                if (result.getValidationResult().getStatus() != ValidatorProtos.ValidationResult.Status.FAIL) continue;
                continue;
            }
            if (hasTemplateAncestor) {
                AttributeSpecUtils.validateAttrValueBelowTemplateTag(parsedTagSpec, context, string, value, result.getValidationResult());
                if (result.getValidationResult().getStatus() == ValidatorProtos.ValidationResult.Status.FAIL) continue;
            }
            if ((attrSpec = attrsByName.get(string)).getValueCount() < 0) {
                attrspecsValidated.add(attrSpec.getName());
                continue;
            }
            ParsedAttrSpec parsedAttrSpec = context.getRules().getParsedAttrSpecs().getParsedAttrSpec(parsedTagSpec.getSpec().getTagName(), string, value, attrSpec);
            if (!parsedAttrSpec.isUsedForTypeIdentifiers(context.getTypeIdentifiers())) {
                ArrayList<String> params22 = new ArrayList<String>();
                params22.add(string);
                params22.add(TagSpecUtils.getTagSpecName(spec));
                context.addError(ValidatorProtos.ValidationError.Code.DISALLOWED_ATTR, context.getLineCol(), params22, TagSpecUtils.getTagSpecUrl(spec), result.getValidationResult());
                continue;
            }
            if (attrSpec.hasDeprecation()) {
                params2 = new ArrayList<String>();
                params2.add(string);
                params2.add(TagSpecUtils.getTagSpecName(spec));
                params2.add(attrSpec.getDeprecation());
                context.addWarning(ValidatorProtos.ValidationError.Code.DEPRECATED_ATTR, context.getLineCol(), params2, attrSpec.getDeprecationUrl(), result.getValidationResult());
            }
            if (attrSpec.getRequiresExtensionCount() > 0) {
                AttributeSpecUtils.validateAttrRequiredExtensions(parsedAttrSpec, context, result.getValidationResult());
            }
            if (attrSpec.hasValueDocCss() || attrSpec.hasValueDocSvgCss()) {
                CssSpecUtils.validateAttrCss(parsedAttrSpec, context, spec, string, value, result);
            } else if (attrSpec.getCssDeclarationCount() > 0) {
                AttributeSpecUtils.validateAttrDeclaration(parsedAttrSpec, context, TagSpecUtils.getTagSpecName(spec), string, value, result.getValidationResult());
            }
            if (!hasTemplateAncestor || !AttributeSpecUtils.attrValueHasTemplateSyntax(value)) {
                AttributeSpecUtils.validateNonTemplateAttrValueAgainstSpec(parsedAttrSpec, context, string, value, spec, result.getValidationResult());
                if (result.getValidationResult().getStatus() == ValidatorProtos.ValidationResult.Status.FAIL) continue;
            }
            if (attrSpec.hasDisallowedValueRegex() && (regex = context.getRules().getPartialMatchCaseiRegex(attrSpec.getDisallowedValueRegex())).matcher(value).find()) {
                params2 = new ArrayList();
                params2.add(string);
                params2.add(TagSpecUtils.getTagSpecName(spec));
                params2.add(value);
                context.addError(ValidatorProtos.ValidationError.Code.INVALID_ATTR_VALUE, context.getLineCol(), params2, TagSpecUtils.getTagSpecUrl(spec), result.getValidationResult());
                continue;
            }
            if (attrSpec.hasMandatory()) {
                mandatoryAttrsSeen.add(parsedAttrSpec.getAttrName());
            }
            if (parsedTagSpec.getSpec().getTagName().equals("BASE") && string.equals("href") && context.hasSeenUrl()) {
                params2 = new ArrayList();
                params2.add(context.firstSeenUrlTagName());
                context.addError(ValidatorProtos.ValidationError.Code.BASE_TAG_MUST_PRECEED_ALL_URLS, context.getLineCol(), params2, TagSpecUtils.getTagSpecUrl(spec), result.getValidationResult());
                continue;
            }
            String mandatoryOneof = attrSpec.getMandatoryOneof();
            if (attrSpec.hasMandatoryOneof()) {
                if (mandatoryOneofsSeen.indexOf(mandatoryOneof) != -1) {
                    params2 = new ArrayList();
                    params2.add(TagSpecUtils.getTagSpecName(spec));
                    params2.add(mandatoryOneof);
                    context.addError(ValidatorProtos.ValidationError.Code.MUTUALLY_EXCLUSIVE_ATTRS, context.getLineCol(), params2, TagSpecUtils.getTagSpecUrl(spec), result.getValidationResult());
                    continue;
                }
                mandatoryOneofsSeen.add(mandatoryOneof);
            }
            if (attrSpec.hasRequiresAncestor()) {
                List<ValidatorProtos.AncestorMarker.Marker> markers = attrSpec.getRequiresAncestor().getMarkerList();
                boolean matchesMarker = false;
                for (ValidatorProtos.AncestorMarker.Marker marker : markers) {
                    if (!context.getTagStack().hasAncestorMarker(marker)) continue;
                    matchesMarker = true;
                    break;
                }
                if (!matchesMarker) {
                    params2 = new ArrayList();
                    params2.add(string);
                    params2.add(TagSpecUtils.getTagSpecName(spec));
                    context.addError(ValidatorProtos.ValidationError.Code.DISALLOWED_ATTR, context.getLineCol(), params2, TagSpecUtils.getTagSpecUrl(spec), result.getValidationResult());
                    continue;
                }
            }
            String mandatoryAnyof = attrSpec.getMandatoryAnyof();
            if (attrSpec.hasMandatoryAnyof()) {
                mandatoryAnyofsSeen.add(mandatoryAnyof);
            }
            attrspecsValidated.add(parsedAttrSpec.getAttrName());
            if (!attrSpec.hasTrigger() || (trigger = attrSpec.getTrigger()) == null) continue;
            boolean hasIfValueRegex = trigger.hasIfValueRegex();
            Pattern ifValueRegexPattern = null;
            if (hasIfValueRegex) {
                ifValueRegexPattern = context.getRules().getFullMatchRegex(trigger.getIfValueRegex());
            }
            if (hasIfValueRegex && !ifValueRegexPattern.matcher(value).matches()) continue;
            triggersToCheck.add(attrSpec);
        }
        if (result.getValidationResult().getStatus() == ValidatorProtos.ValidationResult.Status.FAIL) {
            return;
        }
        for (String string : parsedTagSpec.getMandatoryOneofs()) {
            if (mandatoryOneofsSeen.indexOf(string) != -1) continue;
            params = new ArrayList<String>();
            params.add(TagSpecUtils.getTagSpecName(spec));
            params.add(string);
            context.addError(ValidatorProtos.ValidationError.Code.MANDATORY_ONEOF_ATTR_MISSING, context.getLineCol(), (List<String>)params, TagSpecUtils.getTagSpecUrl(spec), result.getValidationResult());
        }
        for (String string : parsedTagSpec.getMandatoryAnyofs()) {
            if (mandatoryAnyofsSeen.indexOf(string) != -1) continue;
            params = new ArrayList();
            params.add(TagSpecUtils.getTagSpecName(spec));
            params.add(string);
            context.addError(ValidatorProtos.ValidationError.Code.MANDATORY_ANYOF_ATTR_MISSING, context.getLineCol(), (List<String>)params, TagSpecUtils.getTagSpecUrl(spec), result.getValidationResult());
        }
        for (ValidatorProtos.AttrSpec attrSpec : triggersToCheck) {
            for (String alsoRequiresAttr : attrSpec.getTrigger().getAlsoRequiresAttrList()) {
                ValidatorProtos.AttrSpec attrId;
                if (!attrsByName.containsKey(alsoRequiresAttr) || attrspecsValidated.contains((attrId = attrsByName.get(alsoRequiresAttr)).getName())) continue;
                params2 = new ArrayList();
                params2.add(attrId.getName());
                params2.add(TagSpecUtils.getTagSpecName(spec));
                params2.add(attrSpec.getName());
                context.addError(ValidatorProtos.ValidationError.Code.ATTR_REQUIRED_BUT_MISSING, context.getLineCol(), params2, TagSpecUtils.getTagSpecUrl(spec), result.getValidationResult());
            }
        }
        ArrayList<String> missingAttrs = new ArrayList<String>();
        for (ValidatorProtos.AttrSpec mandatory : parsedTagSpec.getMandatoryAttrIds()) {
            if (mandatoryAttrsSeen.contains(mandatory.getName())) continue;
            missingAttrs.add(mandatory.getName());
        }
        Collections.sort(missingAttrs);
        for (String missingAttr : missingAttrs) {
            ArrayList<String> params3 = new ArrayList<String>();
            params3.add(missingAttr);
            params3.add(TagSpecUtils.getTagSpecName(spec));
            context.addError(ValidatorProtos.ValidationError.Code.MANDATORY_ATTR_MISSING, context.getLineCol(), params3, TagSpecUtils.getTagSpecUrl(spec), result.getValidationResult());
        }
        if (spec.hasExtensionSpec() && !seenExtensionSrcAttr) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("src");
            arrayList.add(TagSpecUtils.getTagSpecName(spec));
            context.addError(ValidatorProtos.ValidationError.Code.MANDATORY_ATTR_MISSING, context.getLineCol(), arrayList, TagSpecUtils.getTagSpecUrl(spec), result.getValidationResult());
        }
    }

    public static void validateAttrRequiredExtensions(@Nonnull ParsedAttrSpec parsedAttrSpec, @Nonnull Context context, @Nonnull ValidatorProtos.ValidationResult.Builder validationResult) {
        ValidatorProtos.AttrSpec attrSpec = parsedAttrSpec.getSpec();
        ExtensionsContext extensionsCtx = context.getExtensions();
        for (String requiredExtension : attrSpec.getRequiresExtensionList()) {
            if (extensionsCtx.isExtensionLoaded(requiredExtension)) continue;
            ArrayList<String> params = new ArrayList<String>();
            params.add(attrSpec.getName());
            params.add(requiredExtension);
            context.addError(ValidatorProtos.ValidationError.Code.ATTR_MISSING_REQUIRED_EXTENSION, context.getLineCol(), params, "", validationResult);
        }
    }

    public static void validateAttrDeclaration(@Nonnull ParsedAttrSpec parsedAttrSpec, @Nonnull Context context, @Nonnull String tagSpecName, @Nonnull String attrName, @Nonnull String attrValue, @Nonnull ValidatorProtos.ValidationResult.Builder validationResult) throws IOException, CssValidationException {
        ArrayList<ErrorToken> cssErrors = new ArrayList<ErrorToken>();
        CssParser cssParser = new CssParser(attrValue, context.getLineCol().getLineNumber(), context.getLineCol().getColumnNumber(), cssErrors);
        List<Token> tokenList = cssParser.tokenize();
        List<Declaration> declarations = CssSpecUtils.parseInlineStyle(tokenList, cssErrors);
        for (ErrorToken errorToken : cssErrors) {
            List<String> params = errorToken.getParams();
            params.set(0, tagSpecName);
            context.addError(errorToken.getCode(), errorToken.getLine(), errorToken.getCol(), params, "", validationResult);
        }
        if (cssErrors.size() > 0) {
            return;
        }
        Map<String, ValidatorProtos.CssDeclaration> cssDeclarationByName = parsedAttrSpec.getCssDeclarationByName();
        for (Declaration declaration : declarations) {
            String declarationName = CssSpecUtils.stripVendorPrefix(declaration.getName().toLowerCase());
            if (!cssDeclarationByName.containsKey(declarationName)) {
                ArrayList<String> params = new ArrayList<String>();
                params.add(declaration.getName());
                params.add(attrName);
                params.add(tagSpecName);
                context.addError(ValidatorProtos.ValidationError.Code.DISALLOWED_PROPERTY_IN_ATTR_VALUE, context.getLineCol(), params, context.getRules().getStylesSpecUrl(), validationResult);
                continue;
            }
            ValidatorProtos.CssDeclaration cssDeclaration = cssDeclarationByName.get(declarationName);
            if (cssDeclaration.getValueCaseiList().size() <= 0) continue;
            boolean hasValidValue = false;
            String firstIdent = declaration.firstIdent();
            for (String value : cssDeclaration.getValueCaseiList()) {
                if (!firstIdent.toLowerCase().equals(value)) continue;
                hasValidValue = true;
                break;
            }
            if (hasValidValue) continue;
            ArrayList<String> params = new ArrayList<String>();
            params.add(tagSpecName);
            params.add(declaration.getName());
            params.add(firstIdent);
            context.addError(ValidatorProtos.ValidationError.Code.CSS_SYNTAX_DISALLOWED_PROPERTY_VALUE, context.getLineCol(), params, context.getRules().getStylesSpecUrl(), validationResult);
        }
    }

    public static boolean attrValueHasTemplateSyntax(String value) {
        if (value == null) {
            return false;
        }
        return MUSTACHE_TAG_PATTERN.matcher(value).matches();
    }

    public static void validateNonTemplateAttrValueAgainstSpec(@Nonnull ParsedAttrSpec parsedAttrSpec, @Nonnull Context context, @Nonnull String attrName, @Nonnull String attrValue, @Nonnull ValidatorProtos.TagSpec tagSpec, @Nonnull ValidatorProtos.ValidationResult.Builder result) {
        ArrayList<String> params;
        ValidatorProtos.AttrSpec spec = parsedAttrSpec.getSpec();
        if (spec.hasAddValueToSet()) {
            ValidatorProtos.ValueSetProvision.Builder provision = ValidatorProtos.ValueSetProvision.newBuilder();
            provision.setSet(spec.getAddValueToSet());
            provision.setValue(attrValue);
            result.addValueSetProvisions(provision);
        }
        if (spec.hasValueOneofSet()) {
            ValidatorProtos.ValueSetRequirement.Builder requirement = ValidatorProtos.ValueSetRequirement.newBuilder();
            ValidatorProtos.ValueSetProvision.Builder provision = ValidatorProtos.ValueSetProvision.newBuilder();
            provision.setSet(spec.getValueOneofSet());
            provision.setValue(attrValue);
            requirement.setProvision(provision);
            ArrayList<String> params2 = new ArrayList<String>();
            params2.add(attrName);
            params2.add(TagSpecUtils.getTagSpecName(tagSpec));
            requirement.setErrorIfUnsatisfied(ValidationErrorUtils.populateError(ValidatorProtos.ValidationError.Severity.ERROR, ValidatorProtos.ValidationError.Code.VALUE_SET_MISMATCH, context.getLineCol(), params2, TagSpecUtils.getTagSpecUrl(tagSpec)));
            result.addValueSetRequirements(requirement);
        }
        if (spec.getValueCount() > 0) {
            for (String value : spec.getValueList()) {
                if (!attrValue.equals(value)) continue;
                return;
            }
            params = new ArrayList();
            params.add(attrName);
            params.add(TagSpecUtils.getTagSpecName(tagSpec));
            params.add(attrValue);
            context.addError(ValidatorProtos.ValidationError.Code.INVALID_ATTR_VALUE, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(tagSpec), result);
        } else if (spec.getValueCaseiCount() > 0) {
            for (String value : spec.getValueCaseiList()) {
                if (!attrValue.toLowerCase().equals(value)) continue;
                return;
            }
            params = new ArrayList<String>();
            params.add(attrName);
            params.add(TagSpecUtils.getTagSpecName(tagSpec));
            params.add(attrValue);
            context.addError(ValidatorProtos.ValidationError.Code.INVALID_ATTR_VALUE, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(tagSpec), result);
        } else if (spec.hasValueRegex() || spec.hasValueRegexCasei()) {
            Pattern valueRegex;
            Pattern pattern = valueRegex = spec.hasValueRegex() ? context.getRules().getFullMatchRegex(spec.getValueRegex()) : context.getRules().getFullMatchCaseiRegex(spec.getValueRegexCasei());
            if (!valueRegex.matcher(attrValue).matches()) {
                ArrayList<String> params3 = new ArrayList<String>();
                params3.add(attrName);
                params3.add(TagSpecUtils.getTagSpecName(tagSpec));
                params3.add(attrValue);
                context.addError(ValidatorProtos.ValidationError.Code.INVALID_ATTR_VALUE, context.getLineCol(), params3, TagSpecUtils.getTagSpecUrl(tagSpec), result);
            }
        } else if (spec.hasValueUrl()) {
            AttributeSpecUtils.validateAttrValueUrl(parsedAttrSpec, context, attrName, attrValue, tagSpec, result);
        } else {
            ParsedValueProperties valueProperties = parsedAttrSpec.getValuePropertiesOrNull();
            if (valueProperties != null) {
                AttributeSpecUtils.validateAttrValueProperties(valueProperties, context, attrName, attrValue, tagSpec, result);
            }
        }
    }

    public static void validateAttrValueProperties(@Nonnull ParsedValueProperties parsedValueProperties, @Nonnull Context context, @Nonnull String attrName, @Nonnull String attrValue, @Nonnull ValidatorProtos.TagSpec tagSpec, @Nonnull ValidatorProtos.ValidationResult.Builder result) {
        ArrayList<String> params;
        String[] segments = attrValue.split("[,;]");
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String segment : segments) {
            String[] keyValue = segment.split("=");
            if (keyValue.length < 2) continue;
            properties.put(keyValue[0].trim().toLowerCase(), keyValue[1]);
        }
        Set names = properties.keySet();
        for (String name : names) {
            ArrayList<String> params2;
            String value = (String)properties.get(name);
            Map<String, ValidatorProtos.PropertySpec> valuePropertyByName = parsedValueProperties.getValuePropertyByName();
            if (!valuePropertyByName.containsKey(name)) {
                params = new ArrayList<String>();
                params.add(name);
                params.add(attrName);
                params.add(TagSpecUtils.getTagSpecName(tagSpec));
                context.addError(ValidatorProtos.ValidationError.Code.DISALLOWED_PROPERTY_IN_ATTR_VALUE, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(tagSpec), result);
                continue;
            }
            ValidatorProtos.PropertySpec propertySpec = valuePropertyByName.get(name);
            if (propertySpec.hasValue()) {
                if (propertySpec.getValue().equals(value.toLowerCase())) continue;
                params2 = new ArrayList<String>();
                params2.add(name);
                params2.add(attrName);
                params2.add(TagSpecUtils.getTagSpecName(tagSpec));
                params2.add(value);
                context.addError(ValidatorProtos.ValidationError.Code.INVALID_PROPERTY_VALUE_IN_ATTR_VALUE, context.getLineCol(), params2, TagSpecUtils.getTagSpecUrl(tagSpec), result);
                continue;
            }
            if (!propertySpec.hasValueDouble()) continue;
            Double doubleValue = null;
            try {
                doubleValue = Double.valueOf(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (doubleValue != null && doubleValue.doubleValue() == propertySpec.getValueDouble()) continue;
            params2 = new ArrayList();
            params2.add(name);
            params2.add(attrName);
            params2.add(TagSpecUtils.getTagSpecName(tagSpec));
            params2.add(value);
            context.addError(ValidatorProtos.ValidationError.Code.INVALID_PROPERTY_VALUE_IN_ATTR_VALUE, context.getLineCol(), params2, TagSpecUtils.getTagSpecUrl(tagSpec), result);
        }
        ArrayList<String> notSeen = new ArrayList<String>(parsedValueProperties.getMandatoryValuePropertyNames());
        ArrayList seen = new ArrayList(names);
        notSeen.removeAll(seen);
        for (String name : notSeen) {
            params = new ArrayList();
            params.add(name);
            params.add(attrName);
            params.add(TagSpecUtils.getTagSpecName(tagSpec));
            context.addError(ValidatorProtos.ValidationError.Code.MANDATORY_PROPERTY_MISSING_FROM_ATTR_VALUE, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(tagSpec), result);
        }
    }

    public static void validateAttrValueUrl(@Nonnull ParsedAttrSpec parsedAttrSpec, @Nonnull Context context, @Nonnull String attrName, @Nonnull String attrValue, @Nonnull ValidatorProtos.TagSpec tagSpec, @Nonnull ValidatorProtos.ValidationResult.Builder result) {
        TreeSet<String> maybeUris = new TreeSet<String>();
        if (!attrName.equals("srcset")) {
            maybeUris.add(attrValue);
        } else {
            if (attrValue.equals("")) {
                ArrayList<String> params = new ArrayList<String>();
                params.add(attrName);
                params.add(TagSpecUtils.getTagSpecName(tagSpec));
                context.addError(ValidatorProtos.ValidationError.Code.MISSING_URL, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(tagSpec), result);
                return;
            }
            SrcsetParsingResult parseResult = ParseSrcSetUtils.parseSrcset(attrValue);
            if (!parseResult.isSuccess()) {
                ArrayList<String> params = new ArrayList<String>();
                params.add(attrName);
                params.add(TagSpecUtils.getTagSpecName(tagSpec));
                if (parseResult.getErrorCode() == ValidatorProtos.ValidationError.Code.DUPLICATE_DIMENSION) {
                    context.addError(parseResult.getErrorCode(), context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(tagSpec), result);
                } else {
                    params.add(attrValue);
                    context.addError(parseResult.getErrorCode(), context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(tagSpec), result);
                }
                return;
            }
            for (SrcsetSourceDef image : parseResult.getSrcsetImages()) {
                maybeUris.add(image.getUrl());
            }
        }
        if (maybeUris.size() == 0) {
            ArrayList<String> params = new ArrayList<String>();
            params.add(attrName);
            params.add(TagSpecUtils.getTagSpecName(tagSpec));
            context.addError(ValidatorProtos.ValidationError.Code.MISSING_URL, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(tagSpec), result);
            return;
        }
        UrlErrorInAttrAdapter adapter = new UrlErrorInAttrAdapter(attrName);
        for (String maybeUri : maybeUris) {
            String unescapedMaybeUri = StringEscapeUtils.unescapeHtml4((String)maybeUri);
            AttributeSpecUtils.validateUrlAndProtocol(parsedAttrSpec.getValueUrlSpec(), adapter, context, unescapedMaybeUri, tagSpec, result);
            if (result.getStatus() != ValidatorProtos.ValidationResult.Status.FAIL) continue;
            return;
        }
    }

    public static void validateUrlAndProtocol(@Nonnull ParsedUrlSpec parsedUrlSpec, @Nonnull UrlErrorAdapter adapter, @Nonnull Context context, @Nonnull String urlStr, @Nonnull ValidatorProtos.TagSpec tagSpec, @Nonnull ValidatorProtos.ValidationResult.Builder result) {
        URL url;
        ValidatorProtos.UrlSpec spec = parsedUrlSpec.getSpec();
        if (ONLY_WHITESPACE_PATTERN.matcher(urlStr).matches() && !spec.hasAllowEmpty()) {
            adapter.missingUrl(context, tagSpec, result);
            return;
        }
        String protocol = "";
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            String urlStrTrimmed = urlStr.toLowerCase().trim();
            Matcher matcher = URL_PROTOCOL_PATTERN.matcher(urlStrTrimmed);
            if (matcher.matches()) {
                protocol = matcher.group(1);
            }
            if (!spec.getAllowRelative() && protocol.length() == 0) {
                adapter.disallowedRelativeUrl(context, urlStr, tagSpec, result);
                return;
            }
            if (protocol.length() > 0 && !parsedUrlSpec.isAllowedProtocol(protocol)) {
                adapter.invalidUrl(context, urlStr, tagSpec, result);
            }
            return;
        }
        protocol = url.getProtocol();
        if (protocol.length() > 0 && !parsedUrlSpec.isAllowedProtocol(protocol)) {
            adapter.invalidUrlProtocol(context, protocol, tagSpec, result);
            return;
        }
        if (!spec.getAllowRelative() && protocol.length() == 0) {
            adapter.disallowedRelativeUrl(context, urlStr, tagSpec, result);
            return;
        }
    }

    public static void validateLayout(@Nonnull ParsedTagSpec parsedTagSpec, @Nonnull Context context, @Nonnull ParsedHtmlTag encounteredTag, @Nonnull ValidatorProtos.ValidationResult.Builder result) throws TagValidationException {
        ValidatorProtos.TagSpec spec = parsedTagSpec.getSpec();
        if (!spec.hasAmpLayout()) {
            throw new TagValidationException("Expecting AMP Layout null");
        }
        HashMap<String, String> attrsByKey = encounteredTag.attrsByKey();
        String layoutAttr = attrsByKey.get("layout");
        String widthAttr = attrsByKey.get("width");
        String heightAttr = attrsByKey.get("height");
        String sizesAttr = attrsByKey.get("sizes");
        String heightsAttr = attrsByKey.get("heights");
        boolean hasTemplateAncestor = context.getTagStack().hasAncestor("TEMPLATE");
        if (hasTemplateAncestor && (AttributeSpecUtils.attrValueHasTemplateSyntax(layoutAttr) || AttributeSpecUtils.attrValueHasTemplateSyntax(widthAttr) || AttributeSpecUtils.attrValueHasTemplateSyntax(heightAttr) || AttributeSpecUtils.attrValueHasTemplateSyntax(sizesAttr) || AttributeSpecUtils.attrValueHasTemplateSyntax(heightsAttr))) {
            return;
        }
        ValidatorProtos.AmpLayout.Layout inputLayout = TagSpecUtils.parseLayout(layoutAttr);
        if (layoutAttr != null && inputLayout == ValidatorProtos.AmpLayout.Layout.UNKNOWN) {
            ArrayList<String> params = new ArrayList<String>();
            params.add("layout");
            params.add(TagSpecUtils.getTagSpecName(spec));
            params.add(layoutAttr);
            context.addError(ValidatorProtos.ValidationError.Code.INVALID_ATTR_VALUE, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(spec), result);
            return;
        }
        CssLength inputWidth = new CssLength(widthAttr, true, inputLayout.equals((Object)ValidatorProtos.AmpLayout.Layout.FLUID));
        if (!inputWidth.isValid()) {
            ArrayList<String> params = new ArrayList<String>();
            params.add("width");
            params.add(TagSpecUtils.getTagSpecName(spec));
            params.add(widthAttr);
            context.addError(ValidatorProtos.ValidationError.Code.INVALID_ATTR_VALUE, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(spec), result);
            return;
        }
        CssLength inputHeight = new CssLength(heightAttr, true, inputLayout == ValidatorProtos.AmpLayout.Layout.FLUID);
        if (!inputHeight.isValid()) {
            ArrayList<String> params = new ArrayList<String>();
            params.add("height");
            params.add(TagSpecUtils.getTagSpecName(spec));
            params.add(heightAttr);
            context.addError(ValidatorProtos.ValidationError.Code.INVALID_ATTR_VALUE, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(spec), result);
            return;
        }
        CssLength width = TagSpecUtils.calculateWidth(spec.getAmpLayout(), inputLayout, inputWidth);
        CssLength height = TagSpecUtils.calculateHeight(spec.getAmpLayout(), inputLayout, inputHeight);
        ValidatorProtos.AmpLayout.Layout layout = TagSpecUtils.calculateLayout(inputLayout, width, height, sizesAttr, heightsAttr);
        TagSpecUtils.validateSsrLayout(spec, encounteredTag, inputLayout, inputWidth, inputHeight, sizesAttr, heightsAttr, context, result);
        if (height.isAuto() && layout != ValidatorProtos.AmpLayout.Layout.FLEX_ITEM) {
            ArrayList<String> params = new ArrayList<String>();
            params.add("height");
            params.add(TagSpecUtils.getTagSpecName(spec));
            params.add(heightAttr);
            context.addError(ValidatorProtos.ValidationError.Code.INVALID_ATTR_VALUE, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(spec), result);
            return;
        }
        if (spec.getAmpLayout().getSupportedLayoutsList().indexOf((Object)layout) == -1) {
            ValidatorProtos.ValidationError.Code code;
            ValidatorProtos.ValidationError.Code code2 = code = layoutAttr == null ? ValidatorProtos.ValidationError.Code.IMPLIED_LAYOUT_INVALID : ValidatorProtos.ValidationError.Code.SPECIFIED_LAYOUT_INVALID;
            if (code == ValidatorProtos.ValidationError.Code.IMPLIED_LAYOUT_INVALID && layout == ValidatorProtos.AmpLayout.Layout.CONTAINER && spec.getAmpLayout().getSupportedLayoutsList().indexOf((Object)ValidatorProtos.AmpLayout.Layout.RESPONSIVE) != -1) {
                ArrayList<String> params = new ArrayList<String>();
                params.add(TagSpecUtils.getTagSpecName(spec));
                context.addError(ValidatorProtos.ValidationError.Code.MISSING_LAYOUT_ATTRIBUTES, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(spec), result);
                return;
            }
            ArrayList<String> params = new ArrayList<String>();
            params.add(layout.toString());
            params.add(TagSpecUtils.getTagSpecName(spec));
            context.addError(code, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(spec), result);
            return;
        }
        if (!(layout != ValidatorProtos.AmpLayout.Layout.FIXED && layout != ValidatorProtos.AmpLayout.Layout.FIXED_HEIGHT && layout != ValidatorProtos.AmpLayout.Layout.INTRINSIC && layout != ValidatorProtos.AmpLayout.Layout.RESPONSIVE || height.isSet())) {
            ArrayList<String> params = new ArrayList<String>();
            params.add("height");
            params.add(TagSpecUtils.getTagSpecName(spec));
            context.addError(ValidatorProtos.ValidationError.Code.MANDATORY_ATTR_MISSING, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(spec), result);
            return;
        }
        if (layout == ValidatorProtos.AmpLayout.Layout.FIXED_HEIGHT && width.isSet() && !width.isAuto()) {
            ArrayList<String> params = new ArrayList<String>();
            params.add(widthAttr);
            params.add("width");
            params.add(TagSpecUtils.getTagSpecName(spec));
            params.add("FIXED_HEIGHT");
            params.add("auto");
            context.addError(ValidatorProtos.ValidationError.Code.ATTR_VALUE_REQUIRED_BY_LAYOUT, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(spec), result);
            return;
        }
        if (layout == ValidatorProtos.AmpLayout.Layout.FIXED || layout == ValidatorProtos.AmpLayout.Layout.INTRINSIC || layout == ValidatorProtos.AmpLayout.Layout.RESPONSIVE) {
            if (!width.isSet()) {
                ArrayList<String> params = new ArrayList<String>();
                params.add("width");
                params.add(TagSpecUtils.getTagSpecName(spec));
                context.addError(ValidatorProtos.ValidationError.Code.MANDATORY_ATTR_MISSING, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(spec), result);
                return;
            }
            if (width.isAuto()) {
                ArrayList<String> params = new ArrayList<String>();
                params.add("width");
                params.add(TagSpecUtils.getTagSpecName(spec));
                params.add("auto");
                context.addError(ValidatorProtos.ValidationError.Code.INVALID_ATTR_VALUE, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(spec), result);
                return;
            }
        }
        if (!(layout != ValidatorProtos.AmpLayout.Layout.INTRINSIC && layout != ValidatorProtos.AmpLayout.Layout.RESPONSIVE || width.getUnit().equals(height.getUnit()))) {
            ArrayList<String> params = new ArrayList<String>();
            params.add(TagSpecUtils.getTagSpecName(spec));
            params.add(width.getUnit());
            params.add(height.getUnit());
            context.addError(ValidatorProtos.ValidationError.Code.INCONSISTENT_UNITS_FOR_WIDTH_AND_HEIGHT, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(spec), result);
            return;
        }
        if (heightsAttr != null && layout != ValidatorProtos.AmpLayout.Layout.RESPONSIVE) {
            ArrayList<String> params = new ArrayList<String>();
            params.add("height");
            params.add(TagSpecUtils.getTagSpecName(spec));
            params.add(layout.toString());
            ValidatorProtos.ValidationError.Code code = layoutAttr == null ? ValidatorProtos.ValidationError.Code.ATTR_DISALLOWED_BY_IMPLIED_LAYOUT : ValidatorProtos.ValidationError.Code.ATTR_DISALLOWED_BY_SPECIFIED_LAYOUT;
            context.addError(code, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(spec), result);
            return;
        }
    }

    public static boolean validateAttrInExtension(@Nonnull ValidatorProtos.TagSpec tagSpec, @Nonnull String attrName, @Nonnull String attrValue) throws TagValidationException {
        if (!tagSpec.hasExtensionSpec()) {
            throw new TagValidationException("Expecting extension spec not null");
        }
        ValidatorProtos.ExtensionSpec extensionSpec = tagSpec.getExtensionSpec();
        if (tagSpec.hasExtensionSpec() && AttributeSpecUtils.getExtensionNameAttribute(extensionSpec).equals(attrName)) {
            if (!extensionSpec.getName().equals(attrValue)) {
                if (!extensionSpec.getName().equals(attrValue.toLowerCase())) {
                    throw new TagValidationException("Extension spec name is matched to a lower case attribute value.");
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public static String getExtensionNameAttribute(@Nonnull ValidatorProtos.ExtensionSpec extensionSpec) {
        switch (extensionSpec.getExtensionType()) {
            case CUSTOM_TEMPLATE: {
                return "custom-template";
            }
            case HOST_SERVICE: {
                return "host-service";
            }
        }
        return "custom-element";
    }

    public static void validateAttrNotFoundInSpec(@Nonnull ParsedTagSpec parsedTagSpec, @Nonnull Context context, @Nonnull String attrName, @Nonnull ValidatorProtos.ValidationResult.Builder result) {
        if (!parsedTagSpec.getSpec().hasExplicitAttrsOnly() && DATA_PATTERN.matcher(attrName).matches()) {
            return;
        }
        if (attrName.indexOf("{{") != -1) {
            ArrayList<String> params = new ArrayList<String>();
            params.add(attrName);
            params.add(TagSpecUtils.getTagSpecName(parsedTagSpec.getSpec()));
            context.addError(ValidatorProtos.ValidationError.Code.TEMPLATE_IN_ATTR_NAME, context.getLineCol(), params, context.getRules().getTemplateSpecUrl(), result);
        } else {
            ArrayList<String> params = new ArrayList<String>();
            params.add(attrName);
            params.add(TagSpecUtils.getTagSpecName(parsedTagSpec.getSpec()));
            context.addError(ValidatorProtos.ValidationError.Code.DISALLOWED_ATTR, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(parsedTagSpec.getSpec()), result);
        }
    }

    public static void validateAttrValueBelowTemplateTag(@Nonnull ParsedTagSpec parsedTagSpec, @Nonnull Context context, @Nonnull String attrName, @Nonnull String attrValue, @Nonnull ValidatorProtos.ValidationResult.Builder result) {
        if (AttributeSpecUtils.attrValueHasUnescapedTemplateSyntax(attrValue)) {
            ValidatorProtos.TagSpec spec = parsedTagSpec.getSpec();
            ArrayList<String> params = new ArrayList<String>();
            params.add(attrName);
            params.add(TagSpecUtils.getTagSpecName(spec));
            params.add(attrValue);
            context.addError(ValidatorProtos.ValidationError.Code.UNESCAPED_TEMPLATE_IN_ATTR_VALUE, context.getLineCol(), params, context.getRules().getTemplateSpecUrl(), result);
        } else if (AttributeSpecUtils.attrValueHasPartialsTemplateSyntax(attrValue)) {
            ValidatorProtos.TagSpec spec = parsedTagSpec.getSpec();
            ArrayList<String> params = new ArrayList<String>();
            params.add(attrName);
            params.add(TagSpecUtils.getTagSpecName(spec));
            params.add(attrValue);
            context.addError(ValidatorProtos.ValidationError.Code.TEMPLATE_PARTIAL_IN_ATTR_VALUE, context.getLineCol(), params, context.getRules().getTemplateSpecUrl(), result);
        }
    }

    public static boolean attrValueHasPartialsTemplateSyntax(@Nonnull String value) {
        return PARTIALS_PATTERN.matcher(value).find();
    }

    public static boolean attrValueHasUnescapedTemplateSyntax(@Nonnull String value) {
        return UNESCAPED_OPEN_TAG.matcher(value).find();
    }
}

