/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator.visitor;

import dev.amp.validator.ValidatorProtos;
import dev.amp.validator.css.AtRule;
import dev.amp.validator.css.CssTokenUtil;
import dev.amp.validator.css.CssValidationException;
import dev.amp.validator.css.ErrorToken;
import dev.amp.validator.css.QualifiedRule;
import dev.amp.validator.css.Token;
import dev.amp.validator.visitor.RuleVisitor;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class KeyframesVisitor
implements RuleVisitor {
    @Nonnull
    private final List<ErrorToken> errors;
    private boolean parentIsKeyframesAtRule;

    public KeyframesVisitor(@Nonnull List<ErrorToken> errors) {
        this.errors = errors;
        this.parentIsKeyframesAtRule = false;
    }

    @Override
    public void visitQualifiedRule(@Nonnull QualifiedRule qualifiedRule) throws CssValidationException {
        if (!this.parentIsKeyframesAtRule) {
            ArrayList<String> params = new ArrayList<String>();
            params.add("style");
            params.add(qualifiedRule.ruleName());
            this.errors.add(KeyframesVisitor.createErrorTokenAt(qualifiedRule, ValidatorProtos.ValidationError.Code.CSS_SYNTAX_DISALLOWED_QUALIFIED_RULE_MUST_BE_INSIDE_KEYFRAME, params));
            return;
        }
        if (qualifiedRule.getDeclarations().size() > 0) {
            return;
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add("style");
        params.add(qualifiedRule.ruleName());
        this.errors.add(KeyframesVisitor.createErrorTokenAt(qualifiedRule, ValidatorProtos.ValidationError.Code.CSS_SYNTAX_QUALIFIED_RULE_HAS_NO_DECLARATIONS, params));
    }

    public static ErrorToken createErrorTokenAt(@Nonnull Token positionToken, @Nonnull ValidatorProtos.ValidationError.Code code, @Nonnull List<String> params) throws CssValidationException {
        ErrorToken token = new ErrorToken(code, params);
        CssTokenUtil.copyPosTo(positionToken, token);
        return token;
    }

    @Override
    public void visitAtRule(@Nonnull AtRule atRule) throws CssValidationException {
        switch (atRule.getName()) {
            case "keyframes": 
            case "-moz-keyframes": 
            case "-o-keyframes": 
            case "-webkit-keyframes": {
                if (this.parentIsKeyframesAtRule) {
                    ArrayList<String> params = new ArrayList<String>();
                    params.add("style");
                    this.errors.add(KeyframesVisitor.createErrorTokenAt(atRule, ValidatorProtos.ValidationError.Code.CSS_SYNTAX_DISALLOWED_KEYFRAME_INSIDE_KEYFRAME, params));
                }
                this.parentIsKeyframesAtRule = true;
                return;
            }
        }
    }

    @Override
    public void leaveAtRule(@Nonnull AtRule atRule) {
        this.parentIsKeyframesAtRule = false;
    }
}

