/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr.codecs;

import dev.argon.esexpr.DecodeException;
import dev.argon.esexpr.ESExpr;
import dev.argon.esexpr.ESExprCodec;
import dev.argon.esexpr.ESExprOverrideCodec;
import dev.argon.esexpr.ESExprTag;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class BinaryESExprCodec
extends ESExprCodec<byte[]> {
    @ESExprOverrideCodec(value=byte[].class)
    public static final ESExprCodec<byte[]> INSTANCE = new BinaryESExprCodec();

    private BinaryESExprCodec() {
    }

    @Override
    @NotNull
    public @NotNull Set<@NotNull ESExprTag> tags() {
        return Set.of(new ESExprTag.Binary());
    }

    @Override
    @NotNull
    public ESExpr encode(byte @NotNull [] value) {
        return new ESExpr.Binary(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte @NotNull [] decode(@NotNull ESExpr expr, @NotNull ESExprCodec.FailurePath path) throws DecodeException {
        if (!(expr instanceof ESExpr.Binary)) throw new DecodeException("Expected a binary value", path);
        ESExpr.Binary binary = (ESExpr.Binary)expr;
        try {
            byte[] byArray = binary.b();
            return byArray;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }
}

