/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr.codecs;

import dev.argon.esexpr.DecodeException;
import dev.argon.esexpr.ESExpr;
import dev.argon.esexpr.ESExprCodec;
import dev.argon.esexpr.ESExprCodecOverrideList;
import dev.argon.esexpr.ESExprOverrideCodec;
import dev.argon.esexpr.ESExprTag;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DoubleCodec
extends ESExprCodec<Double> {
    @ESExprCodecOverrideList(value={@ESExprOverrideCodec(value=double.class), @ESExprOverrideCodec(value=Double.class)})
    public static final ESExprCodec<Double> INSTANCE = new DoubleCodec();

    private DoubleCodec() {
    }

    @Override
    @NotNull
    public @NotNull Set<@NotNull ESExprTag> tags() {
        return Set.of(new ESExprTag.Float64());
    }

    @Override
    @NotNull
    public ESExpr encode(@NotNull Double value) {
        return new ESExpr.Float64(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Double decode(@NotNull ESExpr expr, @NotNull ESExprCodec.FailurePath path) throws DecodeException {
        double d2;
        if (!(expr instanceof ESExpr.Float64)) throw new DecodeException("Expected a double value", path);
        ESExpr.Float64 float64 = (ESExpr.Float64)expr;
        try {
            double d;
            d2 = d = float64.d();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return d2;
    }
}

