/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr.codecs;

import dev.argon.esexpr.DecodeException;
import dev.argon.esexpr.ESExpr;
import dev.argon.esexpr.ESExprCodec;
import dev.argon.esexpr.ESExprOverrideCodec;
import dev.argon.esexpr.VarargCodec;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@ESExprOverrideCodec(value=List.class, codecType=ESExprOverrideCodec.CodecType.VARARG)
public class ListVarargCodec<T>
implements VarargCodec<List<T>> {
    private final ESExprCodec<T> elementCodec;

    public ListVarargCodec(ESExprCodec<T> elementCodec) {
        this.elementCodec = elementCodec;
    }

    @Override
    public List<ESExpr> encodeVararg(List<T> value) {
        return value.stream().map(this.elementCodec::encode).toList();
    }

    @Override
    public List<T> decodeVararg(List<ESExpr> exprs, @NotNull VarargCodec.PositionalPathBuilder pathBuilder) throws DecodeException {
        ArrayList<T> values = new ArrayList<T>(exprs.size());
        int i = 0;
        for (ESExpr expr : exprs) {
            T value = this.elementCodec.decode(expr, pathBuilder.pathAt(i));
            values.add(value);
            ++i;
        }
        return values;
    }
}

