/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr.codecs;

import dev.argon.esexpr.DecodeException;
import dev.argon.esexpr.ESExpr;
import dev.argon.esexpr.ESExprCodec;
import dev.argon.esexpr.ESExprOverrideCodec;
import dev.argon.esexpr.ESExprTag;
import dev.argon.esexpr.Unsigned;
import java.math.BigInteger;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class NonNegativeBigIntegerESExprCodec
extends ESExprCodec<BigInteger> {
    @ESExprOverrideCodec(value=BigInteger.class, requiredAnnotations={Unsigned.class})
    public static final ESExprCodec<BigInteger> INSTANCE = new NonNegativeBigIntegerESExprCodec();

    private NonNegativeBigIntegerESExprCodec() {
    }

    @Override
    @NotNull
    public final @NotNull Set<@NotNull ESExprTag> tags() {
        return Set.of(new ESExprTag.Int());
    }

    @Override
    @NotNull
    public final ESExpr encode(@NotNull BigInteger value) {
        return new ESExpr.Int(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public final BigInteger decode(@NotNull ESExpr expr, @NotNull ESExprCodec.FailurePath path) throws DecodeException {
        if (!(expr instanceof ESExpr.Int)) throw new DecodeException("Expected an integer value", path);
        ESExpr.Int intVal = (ESExpr.Int)expr;
        try {
            BigInteger bigInteger;
            BigInteger i = bigInteger = intVal.n();
            if (i.compareTo(BigInteger.ZERO) >= 0) return i;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        throw new DecodeException("Integer value out of range", path);
    }
}

