/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr;

import dev.argon.esexpr.DecodeException;
import dev.argon.esexpr.ESExprCodec;
import dev.argon.esexpr.ESExprTag;
import dev.argon.esexpr.ESExprTagSet;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.eclipse.collections.api.list.primitive.ImmutableByteList;
import org.eclipse.collections.api.list.primitive.ImmutableIntList;
import org.eclipse.collections.api.list.primitive.ImmutableLongList;
import org.eclipse.collections.api.list.primitive.ImmutableShortList;

public sealed interface ESExpr {
    public static final ESExprCodec<ESExpr> CODEC = new ESExprCodec<ESExpr>(){

        @Override
        public ESExprTagSet tags() {
            return new ESExprTagSet.All();
        }

        @Override
        public boolean isEncodedEqual(ESExpr x, ESExpr y) {
            return x.equals(y);
        }

        @Override
        public ESExpr encode(ESExpr value) {
            return value;
        }

        @Override
        public ESExpr decode(ESExpr expr, ESExprCodec.FailurePath path) throws DecodeException {
            return expr;
        }
    };

    public ESExprTag tag();

    public static ESExprCodec<ESExpr> codec() {
        return CODEC;
    }

    public record Null(BigInteger level) implements ESExpr
    {
        @Override
        public ESExprTag tag() {
            return ESExprTag.NULL;
        }
    }

    public record Array128(ImmutableLongList b) implements ESExpr
    {
        @Override
        public ESExprTag tag() {
            return ESExprTag.ARRAY128;
        }
    }

    public record Array64(ImmutableLongList b) implements ESExpr
    {
        @Override
        public ESExprTag tag() {
            return ESExprTag.ARRAY64;
        }
    }

    public record Array32(ImmutableIntList b) implements ESExpr
    {
        @Override
        public ESExprTag tag() {
            return ESExprTag.ARRAY32;
        }
    }

    public record Array16(ImmutableShortList b) implements ESExpr
    {
        @Override
        public ESExprTag tag() {
            return ESExprTag.ARRAY16;
        }
    }

    public record Array8(ImmutableByteList b) implements ESExpr
    {
        @Override
        public ESExprTag tag() {
            return ESExprTag.ARRAY8;
        }
    }

    public record Float64(double d) implements ESExpr
    {
        @Override
        public ESExprTag tag() {
            return ESExprTag.FLOAT64;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            double other;
            if (!(obj instanceof Float64)) return false;
            Float64 float64 = (Float64)obj;
            try {
                double d;
                other = d = float64.d();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            if (Double.doubleToRawLongBits(this.d) != Double.doubleToRawLongBits(other)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return Long.hashCode(Double.doubleToRawLongBits(this.d));
        }
    }

    public record Float32(float f) implements ESExpr
    {
        @Override
        public ESExprTag tag() {
            return ESExprTag.FLOAT32;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            float other;
            if (!(obj instanceof Float32)) return false;
            Float32 float32 = (Float32)obj;
            try {
                float f;
                other = f = float32.f();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            if (Float.floatToRawIntBits(this.f) != Float.floatToRawIntBits(other)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return Float.floatToRawIntBits(this.f);
        }
    }

    public record Float16(short f) implements ESExpr
    {
        @Override
        public ESExprTag tag() {
            return ESExprTag.FLOAT16;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Float16)) return false;
            Float16 float16 = (Float16)obj;
            try {
                short s;
                short other = s = float16.f();
                if (this.f != other) return false;
                return true;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }

        @Override
        public int hashCode() {
            return this.f;
        }

        @Override
        public String toString() {
            return "Float16[f=" + Float.float16ToFloat(this.f) + "]";
        }
    }

    public record Str(String s) implements ESExpr
    {
        @Override
        public ESExprTag tag() {
            return ESExprTag.STR;
        }
    }

    public record Int(BigInteger n) implements ESExpr
    {
        @Override
        public ESExprTag tag() {
            return ESExprTag.INT;
        }
    }

    public record Bool(boolean b) implements ESExpr
    {
        @Override
        public ESExprTag tag() {
            return ESExprTag.BOOL;
        }
    }

    public record Constructor(String constructor, List<ESExpr> args, Map<String, ESExpr> kwargs) implements ESExpr
    {
        @Override
        public ESExprTag tag() {
            return new ESExprTag.Constructor(this.constructor);
        }
    }
}

