/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr.codecs;

import dev.argon.esexpr.DecodeException;
import dev.argon.esexpr.ESExpr;
import dev.argon.esexpr.ESExprCodec;
import dev.argon.esexpr.ESExprCodecOverrideList;
import dev.argon.esexpr.ESExprCodecTags;
import dev.argon.esexpr.ESExprOverrideCodec;
import dev.argon.esexpr.ESExprTag;
import dev.argon.esexpr.ESExprTagSet;

public class DoubleCodec
extends ESExprCodec<Double> {
    @ESExprCodecOverrideList(value={@ESExprOverrideCodec(value=double.class), @ESExprOverrideCodec(value=Double.class)})
    @ESExprCodecTags(scalar={ESExprTag.Scalar.FLOAT64})
    public static final ESExprCodec<Double> INSTANCE = new DoubleCodec();

    private DoubleCodec() {
    }

    @Override
    public ESExprTagSet tags() {
        return ESExprTagSet.of(ESExprTag.FLOAT64);
    }

    @Override
    public boolean isEncodedEqual(Double x, Double y) {
        return Double.doubleToRawLongBits(x) == Double.doubleToRawLongBits(y);
    }

    @Override
    public ESExpr encode(Double value) {
        return new ESExpr.Float64(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Double decode(ESExpr expr, ESExprCodec.FailurePath path) throws DecodeException {
        double d2;
        if (!(expr instanceof ESExpr.Float64)) throw new DecodeException("Expected a double value", path);
        ESExpr.Float64 float64 = (ESExpr.Float64)expr;
        try {
            double d;
            d2 = d = float64.d();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return d2;
    }
}

