/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr.codecs;

import dev.argon.esexpr.DecodeException;
import dev.argon.esexpr.ESExpr;
import dev.argon.esexpr.ESExprCodec;
import dev.argon.esexpr.ESExprCodecTags;
import dev.argon.esexpr.ESExprOverrideCodec;
import dev.argon.esexpr.ESExprTag;
import dev.argon.esexpr.ESExprTagSet;
import java.util.Arrays;
import org.eclipse.collections.api.factory.primitive.LongLists;
import org.eclipse.collections.api.list.primitive.ImmutableLongList;

public class LongArrayCodec
extends ESExprCodec<long[]> {
    @ESExprOverrideCodec(value=long[].class)
    @ESExprCodecTags(scalar={ESExprTag.Scalar.ARRAY64})
    public static final ESExprCodec<long[]> INSTANCE = new LongArrayCodec();

    private LongArrayCodec() {
    }

    @Override
    public ESExprTagSet tags() {
        return ESExprTagSet.of(ESExprTag.ARRAY64);
    }

    @Override
    public boolean isEncodedEqual(long[] x, long[] y) {
        return Arrays.equals(x, y);
    }

    @Override
    public ESExpr encode(long[] value) {
        return new ESExpr.Array64(LongLists.immutable.of(value));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long[] decode(ESExpr expr, ESExprCodec.FailurePath path) throws DecodeException {
        ImmutableLongList b;
        if (!(expr instanceof ESExpr.Array64)) throw new DecodeException("Expected an array64 value", path);
        ESExpr.Array64 array64 = (ESExpr.Array64)expr;
        try {
            ImmutableLongList immutableLongList;
            b = immutableLongList = array64.b();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return b.toArray();
    }
}

