/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr.codecs;

import dev.argon.esexpr.DecodeException;
import dev.argon.esexpr.ESExpr;
import dev.argon.esexpr.ESExprCodec;
import dev.argon.esexpr.ESExprCodecTags;
import dev.argon.esexpr.ESExprOverrideCodec;
import dev.argon.esexpr.ESExprTag;
import dev.argon.esexpr.ESExprTagSet;
import java.util.Arrays;
import org.eclipse.collections.api.factory.primitive.ShortLists;
import org.eclipse.collections.api.list.primitive.ImmutableShortList;

public class ShortArrayCodec
extends ESExprCodec<short[]> {
    @ESExprOverrideCodec(value=short[].class)
    @ESExprCodecTags(scalar={ESExprTag.Scalar.ARRAY16})
    public static final ESExprCodec<short[]> INSTANCE = new ShortArrayCodec();

    private ShortArrayCodec() {
    }

    @Override
    public ESExprTagSet tags() {
        return ESExprTagSet.of(ESExprTag.ARRAY16);
    }

    @Override
    public boolean isEncodedEqual(short[] x, short[] y) {
        return Arrays.equals(x, y);
    }

    @Override
    public ESExpr encode(short[] value) {
        return new ESExpr.Array16(ShortLists.immutable.of(value));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public short[] decode(ESExpr expr, ESExprCodec.FailurePath path) throws DecodeException {
        ImmutableShortList b;
        if (!(expr instanceof ESExpr.Array16)) throw new DecodeException("Expected an array16 value", path);
        ESExpr.Array16 array16 = (ESExpr.Array16)expr;
        try {
            ImmutableShortList immutableShortList;
            b = immutableShortList = array16.b();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return b.toArray();
    }
}

