/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr.codecs;

import dev.argon.esexpr.DecodeException;
import dev.argon.esexpr.ESExpr;
import dev.argon.esexpr.ESExprCodec;
import dev.argon.esexpr.ESExprCodecTags;
import dev.argon.esexpr.ESExprOverrideCodec;
import dev.argon.esexpr.ESExprTag;
import dev.argon.esexpr.ESExprTagSet;

public class StringCodec
extends ESExprCodec<String> {
    @ESExprOverrideCodec(value=String.class)
    @ESExprCodecTags(scalar={ESExprTag.Scalar.STR})
    public static final ESExprCodec<String> INSTANCE = new StringCodec();

    private StringCodec() {
    }

    @Override
    public ESExprTagSet tags() {
        return ESExprTagSet.of(ESExprTag.STR);
    }

    @Override
    public boolean isEncodedEqual(String x, String y) {
        return x.equals(y);
    }

    @Override
    public ESExpr encode(String value) {
        return new ESExpr.Str(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String decode(ESExpr expr, ESExprCodec.FailurePath path) throws DecodeException {
        if (!(expr instanceof ESExpr.Str)) throw new DecodeException("Expected a string value", path);
        ESExpr.Str str = (ESExpr.Str)expr;
        try {
            String string = str.s();
            return string;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }
}

