/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr.codecs;

import dev.argon.esexpr.ESExprCodec;
import dev.argon.esexpr.ESExprCodecOverrideList;
import dev.argon.esexpr.ESExprCodecTags;
import dev.argon.esexpr.ESExprOverrideCodec;
import dev.argon.esexpr.ESExprTag;
import dev.argon.esexpr.Unsigned;
import dev.argon.esexpr.codecs.IntCodecBase;
import java.math.BigInteger;

public class UnsignedShortCodec
extends IntCodecBase<Short> {
    @ESExprCodecOverrideList(value={@ESExprOverrideCodec(value=short.class, requiredAnnotations={Unsigned.class}), @ESExprOverrideCodec(value=Short.class, requiredAnnotations={Unsigned.class})})
    @ESExprCodecTags(scalar={ESExprTag.Scalar.INT})
    public static final ESExprCodec<Short> INSTANCE = new UnsignedShortCodec();

    private UnsignedShortCodec() {
        super(BigInteger.ZERO, BigInteger.valueOf(65535L));
    }

    @Override
    public boolean isEncodedEqual(Short x, Short y) {
        return x.shortValue() == y.shortValue();
    }

    @Override
    protected Short fromBigInt(BigInteger value) {
        return value.shortValue();
    }

    @Override
    protected BigInteger toBigInt(Short value) {
        return BigInteger.valueOf(Short.toUnsignedLong(value));
    }
}

