/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr;

import dev.argon.esexpr.DecodeException;
import dev.argon.esexpr.ESExpr;
import dev.argon.esexpr.ESExprTagSet;
import dev.argon.esexpr.VarargCodec;
import dev.argon.esexpr.codecs.OptionalCodec;
import java.util.Optional;

public abstract class ESExprCodec<T> {
    public abstract ESExprTagSet tags();

    public abstract ESExpr encode(T var1);

    public final T decode(ESExpr expr) throws DecodeException {
        return this.decode(expr, new FailurePath.Current());
    }

    public abstract T decode(ESExpr var1, FailurePath var2) throws DecodeException;

    public abstract boolean isEncodedEqual(T var1, T var2);

    public static <T> ESExprCodec<Optional<T>> optionalCodec(ESExprCodec<T> itemCodec) {
        return new OptionalCodec<T>(itemCodec);
    }

    public static sealed interface FailurePath {
        public FailurePath append(String var1, int var2);

        default public VarargCodec.PositionalPathBuilder appenderWithOffset(String constructor, int offset) {
            return i -> this.append(constructor, offset + i);
        }

        public FailurePath append(String var1, String var2);

        public FailurePath withConstructor(String var1);

        public record Keyword(String constructor, String keyword, FailurePath next) implements FailurePath
        {
            @Override
            public FailurePath append(String constructor, int index) {
                return new Keyword(this.constructor, this.keyword, this.next.append(constructor, index));
            }

            @Override
            public FailurePath append(String constructor, String keyword) {
                return new Keyword(this.constructor, keyword, this.next.append(constructor, keyword));
            }

            @Override
            public FailurePath withConstructor(String constructor) {
                return new Keyword(this.constructor, this.keyword, this.next.withConstructor(constructor));
            }
        }

        public record Positional(String constructor, int index, FailurePath next) implements FailurePath
        {
            @Override
            public FailurePath append(String constructor, int index) {
                return new Positional(this.constructor, this.index, this.next.append(constructor, index));
            }

            @Override
            public FailurePath append(String constructor, String keyword) {
                return new Positional(this.constructor, this.index, this.next.append(constructor, keyword));
            }

            @Override
            public FailurePath withConstructor(String constructor) {
                return new Positional(this.constructor, this.index, this.next.withConstructor(constructor));
            }
        }

        public record Constructor(String name) implements FailurePath
        {
            @Override
            public FailurePath append(String constructor, int index) {
                return new Positional(constructor, index, new Current());
            }

            @Override
            public FailurePath append(String constructor, String keyword) {
                return new Keyword(constructor, keyword, new Current());
            }

            @Override
            public FailurePath withConstructor(String constructor) {
                return new Constructor(constructor);
            }
        }

        public record Current() implements FailurePath
        {
            @Override
            public FailurePath append(String constructor, int index) {
                return new Positional(constructor, index, this);
            }

            @Override
            public FailurePath append(String constructor, String keyword) {
                return new Keyword(constructor, keyword, this);
            }

            @Override
            public FailurePath withConstructor(String constructor) {
                return new Constructor(constructor);
            }
        }
    }
}

