/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr.codecs;

import com.google.common.collect.ImmutableSet;
import dev.argon.esexpr.DecodeException;
import dev.argon.esexpr.ESExpr;
import dev.argon.esexpr.ESExprCodec;
import dev.argon.esexpr.ESExprCodecTags;
import dev.argon.esexpr.ESExprOverrideCodec;
import dev.argon.esexpr.ESExprTag;
import dev.argon.esexpr.ESExprTagSet;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;

@ESExprOverrideCodec(value=Optional.class)
@ESExprCodecTags(scalar={ESExprTag.Scalar.NULL}, unionWithTypeParameters={"T"})
public class OptionalCodec<T>
extends ESExprCodec<Optional<T>> {
    private final ESExprCodec<T> itemCodec;

    public OptionalCodec(ESExprCodec<T> itemCodec) {
        this.itemCodec = itemCodec;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ESExprTagSet tags() {
        ESExprTagSet.All all;
        Record record;
        ESExprTagSet eSExprTagSet = this.itemCodec.tags();
        Objects.requireNonNull(eSExprTagSet);
        ESExprTagSet eSExprTagSet2 = eSExprTagSet;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ESExprTagSet.Tags.class, ESExprTagSet.All.class}, (Object)eSExprTagSet2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                ImmutableSet<ESExprTag> elementTags;
                ESExprTagSet.Tags tags = (ESExprTagSet.Tags)eSExprTagSet2;
                try {
                    ImmutableSet<ESExprTag> immutableSet;
                    elementTags = immutableSet = tags.tags();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                ImmutableSet.Builder tags2 = ImmutableSet.builder();
                tags2.add((Object)ESExprTag.NULL);
                tags2.addAll(elementTags);
                record = new ESExprTagSet.Tags((ImmutableSet<ESExprTag>)tags2.build());
                return record;
            }
            case 1: 
        }
        record = all = (ESExprTagSet.All)eSExprTagSet2;
        return record;
    }

    @Override
    public boolean isEncodedEqual(Optional<T> x, Optional<T> y) {
        if (x.isEmpty()) {
            return y.isEmpty();
        }
        if (y.isEmpty()) {
            return false;
        }
        return this.itemCodec.isEncodedEqual(x.get(), y.get());
    }

    @Override
    public ESExpr encode(Optional<T> value) {
        return value.map(x -> {
            ESExpr res = this.itemCodec.encode(x);
            if (!(res instanceof ESExpr.Null)) return res;
            ESExpr.Null $b$0 = (ESExpr.Null)res;
            try {
                BigInteger patt1$temp;
                BigInteger level = patt1$temp = $b$0.level();
                return new ESExpr.Null(level.add(BigInteger.ONE));
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }).orElseGet(() -> new ESExpr.Null(BigInteger.ZERO));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Optional<T> decode(ESExpr expr, ESExprCodec.FailurePath path) throws DecodeException {
        if (!(expr instanceof ESExpr.Null)) return Optional.of(this.itemCodec.decode(expr));
        ESExpr.Null nullVal = (ESExpr.Null)expr;
        try {
            BigInteger bigInteger;
            BigInteger level = bigInteger = nullVal.level();
            if (level.signum() != 0) return Optional.of(this.itemCodec.decode(new ESExpr.Null(level.subtract(BigInteger.ONE))));
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return Optional.empty();
    }
}

