package dev.array21.pluginstatlib;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.TimeZone;
import java.util.regex.Pattern;

import org.bukkit.Bukkit;

@SuppressWarnings("unused")
public class StatPackage {
	
	private String uuid;
	private long playerCount;
	private long memMb;
	private float mcVersion;
	private String os;
	private int javaVersion;
	private String timezone;
	
	protected StatPackage(String uuid) {
		this.uuid = uuid;
		
		this.playerCount = Bukkit.getOnlinePlayers().size();
		
		final Runtime r = Runtime.getRuntime();
		long usedMemBytes = r.totalMemory() - r.freeMemory();
		this.memMb = Math.round(usedMemBytes * 0.00000001d);
		
		String nmsVersion = Bukkit.getServer().getClass().getPackage().getName().substring(23);
		nmsVersion = nmsVersion.replaceFirst(Pattern.quote("_"), ".");
		nmsVersion = nmsVersion.split(Pattern.quote("_"))[0];
		nmsVersion = nmsVersion.replaceAll(Pattern.quote("v"), "");
		this.mcVersion = Float.valueOf(nmsVersion);
	
		this.os = System.getProperty("os.name");
	
		String sysJVersion = System.getProperty("java.version");
		String[] elems = sysJVersion.split(Pattern.quote("."));
		String jVersion;
		if(elems[0] == "1") {
			jVersion = elems[1];
		} else {
			jVersion = elems[0];
		}
		
		this.javaVersion = Integer.valueOf(jVersion);
		
		this.timezone = TimeZone.getTimeZone(ZoneId.systemDefault()).getID();
	}
}
