package dev.bitbite.networking.protocols;

import dev.bitbite.networking.protocols.http.StatusCode;
import dev.bitbite.networking.protocols.http.HTTPResponse;

/**
 * This class represents a test class for the networking protocols.
 */
public class Test {
    
    /**
     * Private constructor to prevent instantiation.
     */
    private Test() {}

    /**
     * The main method of the Test class.
     * It starts a server and handles incoming requests.
     * @param args The command line arguments.
     */
    public static void main(String[] args) {
        Server server = new Server(Protocols.HTTP, 8080){
            @Override
            public Response handleRequest(Request request, Response response) {
                var httpResponse = (HTTPResponse) response;
                httpResponse.setData("Hello World");
                httpResponse.setStatus(StatusCode._200);
                return response;
            }
        };
        server.start();
    }

}
